/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.droppable;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IPositionable;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HasHandlers;

public interface IDroppableElement extends HasHandlers, IPositionable{
	
	HashSet<Class<? extends IDraggableElement>> getAcceptedTypes();
	
	IDroppableDefaultHandlers getDroppableDefaultHandlers();
	
	/**
	 * North West x,y absolute positions of actual element 
	 * @return
	 */
	IPoint getNorthWestPoint();
	
	/**
	 * South East x,y absolute positions of actual element
	 * @return
	 */
	IPoint getSouthEastPoint();
	
	HandlerManager getHandlerManager();
	
	void addDropHandler(IDropHandler dropHandler);
	
	IDDManager getDDManager();
	
	String getId();
	
	IUIPanel getUIPanel();
}
