/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragProxyHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IProxyDragMoveEvent;
import com.google.gwt.event.shared.GwtEvent;

public class ProxyDragMoveEvent extends GwtEvent<IDragProxyHandler> implements IProxyDragMoveEvent{
	
	public static Type<IDragProxyHandler> TYPE = new Type<IDragProxyHandler>();
	
	private IDragProxy dragProxy;
	private IDragMoveEvent dragMoveEvent;
	
	public ProxyDragMoveEvent(IDragProxy dragProxy,IDragMoveEvent dragStartEvent) {
		this.dragProxy 		= dragProxy;
		this.dragMoveEvent 	= dragStartEvent;
	}
	
	@Override
	protected void dispatch(IDragProxyHandler handler) {
		handler.onProxyDragMove(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IDragProxyHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public IDragProxy getDragProxy() {
		return dragProxy;
	}

	@Override
	public IDragMoveEvent getDragStartEvent() {
		return dragMoveEvent;
	}

}
