/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel;

import java.util.ArrayList;
import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectable;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IMouseState;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggable;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizable;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.ISelectionMarker;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.MouseState;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Util;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DraggableElementDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.ResizableElementDefaultHandlers;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.AbsolutePanel;

/**
 * Graphical indicator when elements are selected Used as 'ui-proxy' for
 * dragging multiple elements.
 * 
 * @author nfleury
 */
@SuppressWarnings("unchecked")
public class SelectionMarker extends AbsolutePanel implements ISelectionMarker,DragHandler,HasClickHandlers {

	private ArrayList<ISelectable> selectedElements;

	private IUIPanel uiPanel;

	private IMouseState mouseState;
	
	private IContainer container;
	

	// ui ability properties
	private IDraggableElementDefaultHandlers draggableElementDefaultHandlers;
	
	private HandlerManager handlerManager;
	
	
	public SelectionMarker(IUIPanel uipanel) {

		this.selectedElements = new ArrayList<ISelectable>();
		this.selectedElements.addAll(uipanel.getSelectedElements().values());

		this.mouseState = new MouseState();
		this.uiPanel = uipanel;

		this.setStyleName("ui-selectionMarker");

		// if all selected elements are draggable make me draggable !
		if (this.selectedElementsAreDraggable()) {
			this.draggableElementDefaultHandlers = new DraggableElementDefaultHandlers(
					this);
		}
		
		this.container 		= uipanel; 
		
		this.handlerManager = new HandlerManager(this);
		
		this.addDragHandler(this);
		
		
		//Stop propagation so that when mouse is up
		//selected elements stays selected
		this.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
					
				event.stopPropagation();
				
			}
		});
	}


	private void computeAndaddToRootPanel() {

		// compute size and position of current marker
		int x;
		int y;

		int width;
		int height;

		if (selectedElements.size() > 0) {
			
			Point nwPoint = Util.getInstance().getNWPointFromElements(selectedElements);
			Point sePoint = Util.getInstance().getSEPointFromElements(selectedElements);
			
			x = (int) nwPoint.getX();
			y = (int) nwPoint.getY();
			
			width = (int) (sePoint.getX() - nwPoint.getX());
			height= (int) (sePoint.getY() - nwPoint.getY());
			
			this.setPixelSize(width, height);

			uiPanel.setSelectionMarker(this, x+uiPanel.getScrollLeft(), y+uiPanel.getScrollTop());


		}
	}

	public void load() {

		// this.makeMeDraggable();
		this.computeAndaddToRootPanel();

	}

	private boolean selectedElementsAreDraggable() {

		boolean result = true;

		for (ISelectable s : selectedElements) {

			if ((s instanceof IDraggable) == false) {
				return false;
			}

		}

		return result;

	}
	

	
	

	
	
	@Override
	public IUIPanel getUIPanel() {
		return uiPanel;
	}

	@Override
	public IMouseState getMouseState() {
		return mouseState;
	}



	@Override
	public IDraggableElementDefaultHandlers getDraggableElementDefaultHandlers() {
		return draggableElementDefaultHandlers;
	}


	@Override
	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}
	
	@Override
	public float getRelativeX() {
		return getAbsoluteLeft()-this.getContainer().getAbsoluteLeft()+uiPanel.getScrollLeft();
	}

	@Override
	public float getRelativeY() {
		return getAbsoluteTop()-this.getContainer().getAbsoluteTop()+uiPanel.getScrollTop();
	}

	@Override
	public void setRelativeX(float x) {
		uiPanel.setSelectionMarker(uiPanel.getSelectionMarker(), (int) x, (int) getRelativeY());
	}

	@Override
	public void setRelativeY(float y) {
		uiPanel.setSelectionMarker(uiPanel.getSelectionMarker(), (int) getRelativeX(),
				(int) y);
	}

//	@Override
//	public HashSet<Class<? extends IUIElement>> getDraggedTypes() {
//		// TODO Auto-generated method stub
//		return null;
//	}

	// /////
	// HANDLERS
	// ////////////////////////////////////////////////////////

	@Override
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
		return addDomHandler(handler, MouseDownEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
		return addDomHandler(handler, MouseMoveEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
		return addDomHandler(handler, MouseWheelEvent.getType());
	}

	@Override
	public String getId() {
		return "ui-selection-marker";
	}


	@Override
	public IContainer getContainer() {
		return container;
	}


	@Override
	public void setContainer(IContainer container) {
		this.container = container;
	}

    public void fireEvent(GwtEvent<?> event) {
    	super.fireEvent(event);
        handlerManager.fireEvent(event);
    }

	
	

	public void addDragHandler(IDragHandler dragHandler) {
		handlerManager.addHandler(DragStartEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragMoveEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(DragStopEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(AcceptedBeforeDropEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(AcceptedAfterDropEvent.TYPE, (DragHandler)dragHandler);
		handlerManager.addHandler(RefusedBeforeDropEvent.TYPE,(DragHandler)dragHandler);
		handlerManager.addHandler(RefusedAfterDropEvent.TYPE,(DragHandler)dragHandler);
	}


	@Override
	public HandlerManager getHandlerManager() {
		return this.handlerManager;
	}


	@Override
	public void onMove(IDragMoveEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onStart(IDragStartEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onStop(IDragStopEvent event) {
		
		// selected X,Y delta
		int dx = (int) (getRelativeX()
				- draggableElementDefaultHandlers.getDragStartX())+getUIPanel().getScrollLeft();
		int dy = (int) (getRelativeY()
				- draggableElementDefaultHandlers.getDragStartY())+getUIPanel().getScrollTop();


		for (ISelectable selectable : selectedElements) {
			// set new X and Y for selected elements
			if (selectable instanceof IConnector == false){
				
				//prevent elements that are contained in other elements
				//to be moved => only elements that are on the panel are moved
				if (selectable.getContainer()==selectable.getUIPanel()){
					selectable.setRelativeX(selectable.getRelativeX() + dx);
					selectable.setRelativeY(selectable.getRelativeY() + dy);
				}	
			
			}
			
			//if selectable is a connector also move all the associated connectorPoints
			if (selectable instanceof IConnector){
				
				IConnector connector = (IConnector) selectable;
				
				for(IConnectorPoint p : (HashSet<IConnectorPoint>)connector.getAllConnectorPoints()){
					
					p.setRelativeX(p.getRelativeX()+dx);
					p.setRelativeY(p.getRelativeY()+dy);
					
				}
				
				connector.refresh();
				
			}
			//if actual selectable is instance of Resizable refresh the resizeUiHandlerPosition
			if (selectable instanceof IResizable){
				
				IResizable sr = (IResizable) selectable;
				
				((ResizableElementDefaultHandlers)sr.getResizableDefaultHandlers()).refreshUIHandlersPositions();
				
			}
			// if selectable is instance of a connectable refresh it magnets
			if (selectable instanceof IConnectable){
				
				IConnectable connectable = (IConnectable) selectable;
				connectable.refreshMagnets();
			}
			
		}
		
	}


	@Override
	public HashSet<Class<? extends IUIElement>> getDraggedTypes() {
		
		HashSet<Class<? extends IUIElement>> draggedTypes = new HashSet<Class<? extends IUIElement>>();
		
		for(IUIElement el:selectedElements){
			
			draggedTypes.add(el.getClass());
			
		}
		
		
		return draggedTypes;
	}


	@Override
	public void onAcceptedAfterDrop(IAcceptedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onRefusedAfterDrop(IRefusedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onRefusedBeforeDrop(IRefusedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}

}
