/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.connectable.events;

import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IRemoveIntermediateConnectorPointEvent;
import com.google.gwt.event.shared.GwtEvent;

public class RemoveIntermediateConnectorPointEvent extends GwtEvent<ConnectorHandler> implements IRemoveIntermediateConnectorPointEvent {
	
	public static Type<ConnectorHandler> TYPE = new Type<ConnectorHandler>();
	
	private IConnectorPoint point;
	
	
	public RemoveIntermediateConnectorPointEvent(IConnectorPoint point) {
		
		this.point = point;
		
	}
	
	@Override
	protected void dispatch(ConnectorHandler handler) {
		handler.onRemoveIntermediateConnectorPoint(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<ConnectorHandler> getAssociatedType() {
		return TYPE;
	}


	@Override
	public IConnectorPoint getConnectorPoint() {
		return point;
	}

	



}
