/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;

import java.util.HashMap;


import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IDefaultUIElementHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IHasBoundsUpdateHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.IResizableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.resizable.events.IResizeStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.PositionChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.events.SizeChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.ebmwebsourcing.geasytools.geasyui.impl.resizable.events.ResizeHandler;
import com.google.gwt.user.client.Window;

public class DefaultBoundsUpdateHandlers implements IDefaultUIElementHandlers {
	
	private IHasBoundsUpdateHandler element;
	
	
	private float oldWidth;
	private float oldHeight;
	
	private float oldX;
	private float oldY;
	
	
	private HashMap<IUIElement,Size> childrenSize;
	
	public DefaultBoundsUpdateHandlers(IHasBoundsUpdateHandler hasBoundUpdateHandler) {
		this.element = hasBoundUpdateHandler;
		this.childrenSize = new HashMap<IUIElement, Size>();
	}
	
	@Override
	public void attachDefaultHandlers() {
			
		if (element instanceof IDraggableElement){
			
			IDraggableElement draggable = (IDraggableElement) element;
			
			draggable.addDragHandler(new DragHandler() {
				
				@Override
				public void onRefusedBeforeDrop(IRefusedBeforeDropEvent event) {}
				
				@Override
				public void onRefusedAfterDrop(IRefusedAfterDropEvent event) {}
				
				@Override
				public void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event) {}
				
				@Override
				public void onAcceptedAfterDrop(IAcceptedAfterDropEvent event) {}
				
				@Override
				public void onStop(IDragStopEvent event) {
					
					element.fireEvent(new PositionChangeEvent(oldX, oldY, element.getRelativeX()+element.getUIPanel().getScrollLeft()+Window.getScrollLeft(), element.getRelativeY()+element.getUIPanel().getScrollTop()+Window.getScrollTop()));
					
				}
				
				@Override
				public void onStart(IDragStartEvent event) {
					
					oldX = element.getRelativeX();
					oldY = element.getRelativeY();
					
				}
				
				@Override
				public void onMove(IDragMoveEvent event) {}
			});
		}
		
		if (element instanceof IResizableElement){
		
		IResizableElement resizable = (IResizableElement) element;	
			
		resizable.addResizeHandler(new ResizeHandler() {
			
			@Override
			public void onStop(IResizeStopEvent event) {
				
				element.fireEvent(new SizeChangeEvent(oldWidth, oldHeight, element.getWidth(), element.getHeight()));
				
				//if actual element is a container
				//check for each child is size changed
				//if yes fire event on them to
				for(IUIElement el:childrenSize.keySet()){
					
					float childOldWidth = childrenSize.get(el).getWidth();
					float childOldHeight = childrenSize.get(el).getHeight(); 
					
					if (childOldWidth!=el.getWidth() 
							|| childOldHeight!=el.getHeight()){
						
						if (el instanceof IHasBoundsUpdateHandler){
							
							IHasBoundsUpdateHandler buh = (IHasBoundsUpdateHandler) el;
							
							buh.fireEvent(new SizeChangeEvent(childOldWidth, childOldHeight, el.getWidth(), el.getHeight()));
							
						}
						
					}
					
				}
				
			}
			
			@Override
			public void onStart(IResizeStartEvent event) {
				
				oldWidth = element.getWidth();
				oldHeight = element.getHeight();
				
				//if actual element is a container
				//store each child size before resize
				if (element instanceof IContainer){
					
					IContainer container = (IContainer) element;
					
					childrenSize.clear();
					
					for(IUIElement el:container.getChildrenUIElements().values()){
						
						childrenSize.put(el, new Size(el.getWidth(), el.getHeight()));
						
					}
					
				}
				
				
				
			}
			
			@Override
			public void onResize(IResizeEvent event) {}
		});
		
		}
		
	}

	@Override
	public IHasBoundsUpdateHandler getUIElement() {
		return element;
	}
	
	private class Size{
		
	private float width;
	private float height;
		
		public Size(float width,float height) {
			this.width = width;
			this.height = height;
		}
		
		public float getWidth() {
			return width;
		}
		public float getHeight() {
			return height;
		}
		
	}

}

