/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IElementContext;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;

public class ElementContext implements IElementContext{
	
	private float initialLeft;
	
	private float initialTop;
	
	private float initialWidth;
	
	private float initialHeight;
	
	private IUIElement uiElement;
	
	public ElementContext(IUIElement element) {
		
		this.uiElement = element;
		
	}
	
	@Override
	public float getInintialLeft() {
		return initialLeft;
	}

	@Override
	public float getInitialTop() {
		return initialTop;
	}

	@Override
	public IUIElement getUIElement() {
		return uiElement;
	}

	@Override
	public void setInitialLeft(float left) {
		this.initialLeft = left;
	}

	@Override
	public void setInitialTop(float top) {
		this.initialTop = top;
	}

	@Override
	public float getInitialHeight() {
		return this.initialHeight;
	}

	@Override
	public float getInitialWidth() {
		return this.initialWidth;
	}

	@Override
	public void setInitialHeight(float height) {
		this.initialHeight = height;
	}

	@Override
	public void setInitialWidth(float width) {
		this.initialWidth = width;
	}

}
