/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.droppable;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.google.gwt.event.shared.GwtEvent;

public class OverEvent extends GwtEvent<DropHandler> implements IOverEvent{
	
	public static Type<DropHandler> TYPE = new Type<DropHandler>();
	
	private IDraggableElement draggableElement;
	
	public OverEvent(IDraggableElement draggedElement) {
		this.draggableElement = draggedElement;
	}

	@Override
	protected void dispatch(DropHandler handler) {
		handler.onOver(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<DropHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public IDraggableElement getDraggableElement(){
		return this.draggableElement;
	}
	
}
