/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel.events;

import java.util.HashMap;

import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.google.gwt.event.shared.GwtEvent;

public class SelectedElementsEvent extends GwtEvent<IUIPanelHandler> implements ISelectedElementsEvent{
	
	public static Type<IUIPanelHandler> TYPE= new Type<IUIPanelHandler>();
	
	private HashMap<String,ISelectable> selectedElements;
	
	public SelectedElementsEvent(HashMap<String,ISelectable> selectedElements) {
		this.selectedElements = selectedElements;
	}
	
	@Override
	protected void dispatch(IUIPanelHandler handler) {
		handler.onSelectUIElement(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IUIPanelHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public HashMap<String,ISelectable> getSelectedElements() {
		return selectedElements;
	}
	
	
}
