/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IMouseState;

public class MouseState implements IMouseState{
	
	private boolean mouseDown;
	private boolean mouseMove;
	private boolean mouseOver;
	private boolean mouseUp;
	
	
	
	
	@Override
	public boolean isMouseDown() {
		return mouseDown;
	}

	@Override
	public boolean isMouseMove() {
		return mouseMove;
	}

	@Override
	public boolean isMouseOver() {
		return mouseOver;
	}

	@Override
	public boolean isMouseUp() {
		return mouseUp;
	}

	@Override
	public void setMouseDown(boolean mouseDown) {
		this.mouseDown = mouseDown;
		GlobalMouseState.getInstance().setMouseDown(mouseDown);
	}

	@Override
	public void setMouseMove(boolean mouseMove) {
		this.mouseMove = mouseMove;
		GlobalMouseState.getInstance().setMouseMove(mouseMove);
	}

	@Override
	public void setMouseOver(boolean mouseOver) {
		this.mouseOver = mouseOver;
		GlobalMouseState.getInstance().setMouseOver(mouseOver);
	}

	@Override
	public void setMouseUp(boolean mouseUp) {
		this.mouseUp = mouseUp;
		GlobalMouseState.getInstance().setMouseDown(mouseUp);
	}

	
	
	
}
