/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core.events;

import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IBoundsUpdateHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IPositionChangeEvent;
import com.google.gwt.event.shared.GwtEvent;


public class PositionChangeEvent extends GwtEvent<IBoundsUpdateHandler> implements IPositionChangeEvent{
	
	private float oldRelativeX;
	private float oldRelativeY;
	private float newRelativeX;
	private float newRelativeY;
	
	public static Type<IBoundsUpdateHandler> TYPE = new Type<IBoundsUpdateHandler>();
	
	public PositionChangeEvent(float oldRelativeX,float oldRelativeY,float newRelativeX,float newRelativeY) {
		
		this.oldRelativeX = oldRelativeX;
		this.oldRelativeY = oldRelativeY;
		this.newRelativeX = newRelativeX;
		this.newRelativeY = newRelativeY;
	
	}
	
	
	@Override
	protected void dispatch(IBoundsUpdateHandler handler) {
		handler.onPositionChange(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IBoundsUpdateHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public float getNewRelativeX() {
		return newRelativeX;
	}

	@Override
	public float getNewRelativeY() {
		return newRelativeY;
	}

	@Override
	public float getOldRelativeX() {
		return oldRelativeX;
	}

	@Override
	public float getOldRelativeY() {
		return oldRelativeY;
	}

}
