/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.palette;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.palette.IPaletteGroup;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class PaletteGroup extends Composite implements IPaletteGroup{

	private String name;
	private LinkedHashSet<IHasDragProxy> elements;
	private IPaletteGroup parent;
	
	private DisclosurePanel mainPanel;
	
	private VerticalPanel vp;
	
	public PaletteGroup(String name) {
		
		this.name = name;
		this.elements = new LinkedHashSet<IHasDragProxy>();
		this.vp 		= new VerticalPanel();
		this.mainPanel  = new DisclosurePanel(name);
		this.mainPanel.setOpen(true);
		this.mainPanel.setContent(vp);
		initWidget(mainPanel);
		
		this.setStyleName("ui-palette-group");
	}
	
	
	@Override
	public void addElement(IHasDragProxy dragProxy) {
		this.elements.add(dragProxy);
		this.vp.add((Widget) dragProxy);
	}

	@Override
	public LinkedHashSet<IHasDragProxy> getElements() {
		return elements;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public IPaletteGroup getParentGroup() {
		return parent;
	}


	@Override
	public void addParentGroup(IPaletteGroup group) {
		this.vp.add((Widget) group);
		group.setParentGroup(this);
	}


	@Override
	public void setParentGroup(IPaletteGroup group) {
		this.parent = group;
	}


    @Override
    public void clearGroup() {
        this.vp.clear();
    }


	@Override
	public void removeElement(IHasDragProxy dragProxy) {
		this.vp.remove(dragProxy);
		this.elements.remove(dragProxy);
	}

}
