/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.input;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.ebmwebsourcing.geasytools.widgets.core.impl.input.AbstractComboBox;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.form.event.ComboBoxListenerAdapter;

public class ComboBox<T> extends AbstractComboBox<T>{
	
	
	private com.gwtext.client.widgets.form.ComboBox comboBox;
	private T value;
	
	private List<T> valuesIndex;
	private int index;
	private ArrayReader reader;
	
	public ComboBox() {
		
		this.valuesIndex		= new ArrayList<T>();
		
		MemoryProxy proxy 		= new MemoryProxy(new Object[0][2]);  
		this.comboBox		 	= new com.gwtext.client.widgets.form.ComboBox();  
		
		RecordDef recordDef 	= new RecordDef(  
                new FieldDef[]{  
                        new StringFieldDef("label"),
                        new ObjectFieldDef("value")
                }  
        );  
		
		this.reader = new ArrayReader(recordDef);  
		Store store = new Store(proxy, reader);  
		store.load();
		
		comboBox.setStore(store);
		comboBox.setDisplayField("label");
		comboBox.setMode(com.gwtext.client.widgets.form.ComboBox.LOCAL);
		comboBox.setTriggerAction(com.gwtext.client.widgets.form.ComboBox.ALL);
		comboBox.setForceSelection(true);
		comboBox.setAllowBlank(false);
		comboBox.setEditable(false);
		
		/////////Attach listener on combo to set value
		comboBox.addListener(new ComboBoxListenerAdapter() {
			
			
			public void onSelect(com.gwtext.client.widgets.form.ComboBox comboBox, Record record, int index) {
				
				value = (T) record.getAsObject("value");
				setValue(value);
				ValueChangeEvent.fire(ComboBox.this, value);
				
			}
		
		});
		comboBox.setVisible(false);//when initializing widget is automatically added to rootpanel
		initWidget(comboBox);
	}
	
	
	public void addItem(T value, String label) {
		super.addItem(value, label);
		this.valuesIndex.add(index, value);
		index++;
		reloadComboBox();
		
	};
	
	public void addItem(T item) {
		super.addItem(item);
		this.valuesIndex.add(index, value);
		index++;
		reloadComboBox();
	};
	
	@Override
	protected void onLoad() {
		comboBox.setVisible(true);
	}
	

	
	@Override
	public void clear() {
		super.clear();
		index = 0;
		valuesIndex.clear();
		comboBox.clearValue();
		reloadComboBox();
	}
	
	
	@Override
	public void clearValue(){
		comboBox.clearValue();
	}
	
	
	private void reloadComboBox(){
		
		MemoryProxy proxy = new MemoryProxy(getData());
		
		Store storeTemp = new Store(proxy,reader);
		storeTemp.reload();
		comboBox.getStore().removeAll();
		comboBox.getStore().add(storeTemp.getRecords());
		
		
	}
	
	private Object[][] getData(){
		
		Object[][] objects = new Object[getItems().size()][2];
		
		Iterator<String> keysIterator = getItems().keySet().iterator();
		
		int i = 0;
		
		while(keysIterator.hasNext()){
			
			String label 	= keysIterator.next();
			T value			= getItems().get(label);
			
			objects[i][0]   = label;
			objects[i][1]	= value;
			
			i++;
		}
		
		
		return objects;
	}
	
	
	@Override
	public T getValue() {
		return value;
	}

	@Override
	public void setValue(T value) {
		
		this.value = value;
		
		int selectedIndex = 0;
		
		///retrieve the index to select element
		for(int i=0;i<valuesIndex.size();i++){
			
			T v = valuesIndex.get(i);
			
			if (v.equals(value)){
				
				selectedIndex = i;
				
				break;
			}
			
		}
		
		comboBox.select(selectedIndex, true);
		
	}
	
	
	public void setWidth(int width){
		
		this.comboBox.setWidth(width);
		
	}
	
	
	@Override
	public void setValue(T value, boolean fireEvents) {
		
		if (fireEvents==false){
			setValue(value);
		}else{
			setValue(value);
			ValueChangeEvent.fire(this, value);
		}
		
	}

	
	
}
