/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.GridHandler;
import com.google.gwt.user.client.ui.Composite;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.ObjectFieldDef;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.EditorGridPanel;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.event.GridCellListener;

public abstract class AbstractGrid<T> extends Composite {
	
	protected EditorGridPanel gridPanel;
	protected final String OBJECT_REF = "ObjectRef";
	
	protected List<T> data;
	protected RecordDef recordDef;
	protected Store store;
	private ArrayReader reader;
	
	public AbstractGrid() {
		
		this.data = new ArrayList<T>();
		
		buildGrid();
	
		this.initWidget(gridPanel);
	
	}
	

	
	protected void buildGrid(){
		
		this.gridPanel 		= new EditorGridPanel();
		this.gridPanel.setBorder(false);
		this.gridPanel.setHeader(false);

		//recoredDef keep objects refs
		List<FieldDef> fieldDefsUpdate = new ArrayList<FieldDef>();
		fieldDefsUpdate.addAll(Arrays.asList(getFieldDef()));
		fieldDefsUpdate.add(new ObjectFieldDef(OBJECT_REF));
		
		this.recordDef = new RecordDef(fieldDefsUpdate.toArray(new FieldDef[fieldDefsUpdate.size()]));
		
		this.reader  = new ArrayReader(recordDef);
		
		MemoryProxy	proxy   = new MemoryProxy(this.convertDataListToObjecArray(data));
		
		this.store 		= new Store(proxy,reader);

		gridPanel.setStore(store);
		
		store.load();
		
		BaseColumnConfig[] columns 	= getColumnsConfig().toArray(new BaseColumnConfig[getColumnsConfig().size()]); 
			
		ColumnModel columnModel 	= new ColumnModel(columns);
		
		gridPanel.setColumnModel(columnModel);
		
		gridPanel.setFrame(true);
		gridPanel.setStripeRows(true);
		gridPanel.setFrame(true);
		
		//fire cellclick event
		gridPanel.addGridCellListener(new GridCellListener() {
			
			@Override
			public void onCellDblClick(GridPanel grid, int rowIndex, int colIndex,
					EventObject e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onCellContextMenu(GridPanel grid, int rowIndex, int cellIndex,
					EventObject e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onCellClick(GridPanel grid, int rowIndex, int colIndex,
					EventObject e) {

				fireEvent(new CellClickEvent(rowIndex, colIndex));
				
			}
		});
		

	}
	
	protected Object[][] convertDataListToObjecArray(List<T> data){
		
		Object[][] objects = new Object[data.size()][];
		int notValid = 0;
		for(int i=0;i<data.size();i++){
			
			if (isValid(data.get(i))){
				
				if (notValid==0){
					objects[i] = convertDataToObjectWithObjectRef(data.get(i));
				}else{
					objects[i-notValid] = convertDataToObjectWithObjectRef(data.get(i));
				}
			
			}else{
				notValid++;
			}
			
		}
		
	
		
		return objects;
	}
	
	protected abstract Object[] convertDataToObject(T data);
	
	protected abstract boolean isValid(T data);
	
	public void load(List<T> data){
		
		if (data!=this.data){
		clearRecords();
		
		//add every elements in provided by external data set into internal data set
		for(T e:data){
			this.data.add(e);
		}
		
		MemoryProxy proxy = new MemoryProxy(convertDataListToObjecArray(data));
		
		Store storeTemp = new Store(proxy,reader);
		storeTemp.reload();
		
		gridPanel.getStore().removeAll();
		gridPanel.getStore().add(storeTemp.getRecords());
		
		
		
		gridPanel.doLayout();
		
		}
	
	}
	
	public void refresh(){
		load(data);
	}
	
	public void clearRecords(){
		
		data.clear();
		for(Record r:gridPanel.getStore().getRecords()){
			store.remove(r);
		}
		
	}
	
	
	protected abstract List<BaseColumnConfig> getColumnsConfig();
	
	protected abstract FieldDef[] getFieldDef();
	
	protected Object[] convertDataToObjectWithObjectRef(T data){

		//add actual object ref into its own definition 
		//in order to be retrieved more easily later on
		Object[] object = this.convertDataToObject(data);
		
		List<Object> l = Arrays.asList(object);
		
		List<Object> newList = new ArrayList<Object>();
		newList.addAll(l);
		newList.add(data);
		
		return newList.toArray();
	}
	
	public void setWidth(int width){
		gridPanel.setWidth(width);
	}
	
	public void setHeight(int height){
		gridPanel.setHeight(height);
	}
	
	public void setTitle(String title){
		gridPanel.setTitle(title);
	}
	
	protected EditorGridPanel getGridPanel() {
		return gridPanel;
	}
	
	public void addHandler(GridHandler handler){
		addHandler(handler, CellClickEvent.TYPE);
	}
	
}
