/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.treepanel;

import com.ebmwebsourcing.geasytools.widgets.ext.api.treepanel.ITreeNode;
import com.ebmwebsourcing.geasytools.widgets.ext.api.treepanel.ITreePanel;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.treepanel.AbstractTreePanel;
import com.gwtext.client.data.Node;
import com.gwtext.client.widgets.tree.TreeNode;

public class TreePanel extends AbstractTreePanel implements ITreePanel{

	private com.gwtext.client.widgets.tree.TreePanel treePanel;
	
	public TreePanel(ITreeNode rootNode) {
		this.treePanel = new com.gwtext.client.widgets.tree.TreePanel();
		treePanel.setVisible(false);
		treePanel.setRootVisible(false);
		this.setRootNode(rootNode);
		initWidget(treePanel);
	}
	
	@Override
	protected void onLoad() {
		treePanel.setVisible(true);
		super.onLoad();
	}
	
	@Override
	public void setRootNode(ITreeNode node) {
		treePanel.setRootNode((Node) node);
		super.setRootNode(node);
	}

	@Override
	public void setActiveItem(ITreeNode treeNode) {
		treePanel.getSelectionModel().select((TreeNode) treeNode);
	}

	@Override
	public void removeNode(ITreeNode node) {
		treePanel.getRootNode().removeChild((Node) node);
	}

}
