/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer;

import java.util.List;

import com.ebmwebsourcing.geasytools.widgets.core.api.button.IButton;
import com.ebmwebsourcing.geasytools.widgets.core.api.panel.IPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFile;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolder;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerPanelHandler;
import com.google.gwt.event.shared.HasHandlers;

public interface IFileExplorerPanel extends IPanel,HasHandlers{
	
	void setTitle(String title);
	
	String getTitle();
	
	void setFolders(List<IFolder> folders);
	
	void setFiles(List<IFile> files);
	
	IButton getValidateBtn();
	
	IButton getCancelBtn();
	
	void addHandler(IFileExplorerPanelHandler handler);
}
