/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.api.notification;

import com.ebmwebsourcing.geasytools.widgets.ext.api.notification.event.INotificationBubbleHandler;
import com.google.gwt.event.dom.client.HasMouseOutHandlers;
import com.google.gwt.event.dom.client.HasMouseOverHandlers;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.ui.Widget;

public interface INotificationBubble extends HasHandlers,HasMouseOverHandlers,HasMouseOutHandlers{

	int getWidth();
	
	int getHeight();
	
	String getTitle();
	
	void addWidget(Widget widget);
	
	INotificationBubbleConfiguration getConfiguration();

	void show();
	
	void hide();
	
	void setIndicatorVisible(boolean visible);

	void setTitleVisible(boolean visible);
	
	void setMessageVisible(boolean visible);
	
	void setNoticeIconVisible(boolean visible);
	
	void addHandler(INotificationBubbleHandler handler);

}
