/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.file;

import java.util.Date;
import java.util.HashMap;

import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFile;

public class File implements IFile {
	
	private String author;
	private Date creationDate;
	private String extension;
	private Date lastmodificationDate;
	private String name;
	
	private HashMap<String, Object> attributes;
	
	public File() {
		this.attributes = new HashMap<String, Object>();
	}
	
	@Override
	public String getAuthor() {
		return author;
	}

	@Override
	public Date getCreationDate() {
		return creationDate;
	}

	@Override
	public String getExtension() {
		return extension;
	}

	@Override
	public Date getLastModificationDate() {
		return lastmodificationDate;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public void setAuthor(String author) {
		this.author = author;
	}

	@Override
	public void setCreationDate(Date date) {
		this.creationDate = date;
	}

	@Override
	public void setExtension(String extension) {
		this.extension = extension;
	}

	@Override
	public void setLastModificationDate(Date date) {
		this.lastmodificationDate = date;
	}

	@Override
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public Object getValue(String attributeName) {
		return attributes.get(attributeName);
	}

	@Override
	public void setAttribute(String attributeName, Object value) {
		attributes.put(attributeName, value);
	}

}
