/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event;

import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolder;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderSelectedEvent;
import com.google.gwt.event.shared.GwtEvent;

public class FolderSelectedEvent extends GwtEvent<IFolderPanelHandler> implements IFolderSelectedEvent{

	public static Type<IFolderPanelHandler> TYPE = new Type<IFolderPanelHandler>();
	
	private IFolder folder;
	
	public FolderSelectedEvent(IFolder folder) {
		this.folder = folder;
	}
	
	
	@Override
	protected void dispatch(IFolderPanelHandler handler) {
		handler.onFolderSelected(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IFolderPanelHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public IFolder getFolder() {
		return folder;
	}

}
