/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.file.explorer;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFile;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFileSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFilesLoadedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFoldersLoadedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.IFileExplorerPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerCancelEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerValidateEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FilesLoadedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FilesSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FoldersLoadedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.explorer.event.FileExplorerCancelEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.explorer.event.FileExplorerValidateEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;

public abstract class FileExplorerPanel extends Composite implements IFileExplorerPanel{
	
	private HashSet<IFile> lastSelectedFiles;
	
	public FileExplorerPanel() {
		
		this.addHandler(new IFileExplorerPanelHandler() {
			
			@Override
			public void onFoldersLoaded(IFoldersLoadedEvent event) {
			
				
			}
			
			@Override
			public void onFolderSelected(IFolderSelectedEvent event) {
			
				
			}
			
			@Override
			public void onFilesSelected(IFileSelectedEvent event) {
				
				lastSelectedFiles = event.getFiles();
				
			}
			
			@Override
			public void onFilesLoaded(IFilesLoadedEvent event) {
			
				
			}
			
			@Override
			public void onValidate(IFileExplorerValidateEvent event) {
			
				
			}
			
			@Override
			public void onCancel(IFileExplorerCancelEvent event) {
			
				
			}
		});
		
		
		getValidateBtn().addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				fireEvent(new FileExplorerValidateEvent(lastSelectedFiles));
				
			}
		});
		
		getCancelBtn().addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				
				fireEvent(new FileExplorerCancelEvent());
				
			}
		});
		
		
	}
	
	
	@Override
	public void addHandler(IFileExplorerPanelHandler handler) {
		this.addHandler(handler, FileExplorerCancelEvent.TYPE);
		this.addHandler(handler,FileExplorerValidateEvent.TYPE);
		this.addHandler(handler,FolderSelectedEvent.TYPE);
		this.addHandler(handler,FilesSelectedEvent.TYPE);
		this.addHandler(handler,FilesLoadedEvent.TYPE);
		this.addHandler(handler,FoldersLoadedEvent.TYPE);
	}


}
