/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.file.explorer.event;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFile;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerValidateEvent;
import com.google.gwt.event.shared.GwtEvent;

public class FileExplorerValidateEvent extends GwtEvent<IFileExplorerPanelHandler> implements IFileExplorerValidateEvent{
	
	public static Type<IFileExplorerPanelHandler> TYPE = new Type<IFileExplorerPanelHandler>();
	
	private HashSet<IFile> files;
	
	public FileExplorerValidateEvent(HashSet<IFile> files) {
		this.files = files;
	}
	
	@Override
	protected void dispatch(IFileExplorerPanelHandler handler) {
		handler.onValidate(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IFileExplorerPanelHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public HashSet<IFile> getFiles() {
		return files;
	}

}
