/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.tabpanel;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.widgets.core.api.panel.IPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.tabpanel.ITabPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.tabpanel.event.ITabPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.tabpanel.event.PanelSelectedEvent;
import com.google.gwt.user.client.ui.Composite;

public abstract class AbstractTabPanel extends Composite implements ITabPanel{
	
	private List<IPanel> panels;
	
	
	public AbstractTabPanel() {
		
		this.panels = new ArrayList<IPanel>();
		
	}
	
	@Override
	public void addHandler(ITabPanelHandler handler) {
		this.addHandler(handler, PanelSelectedEvent.TYPE);
	}

	@Override
	public void addPanel(IPanel panel) {
		this.panels.add(panel);
	}

	@Override
	public IPanel[] getPanels() {
		return this.panels.toArray(new IPanel[panels.size()]);
	}
	
	@Override
	public void removePanel(IPanel panel) {
		this.panels.remove(panel);
	}
	

}
