/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client;

import java.util.List;

@SuppressWarnings(value = { "unchecked" })
public class CloneManager<T> {
	
	
	private static CloneManager instance;

	
	static{
		instance = new CloneManager();
	}
	
	private CloneManager(){
		
	}
	
	public static CloneManager getInstance(){
		return instance;
	}
	
	public void clone(T objectToClone,T clonedObject,List<String> methodNames){
		
		if (clonedObject instanceof ModelProxy){
			
			ModelProxy mp = (ModelProxy) clonedObject;
			
			if(methodNames!=null && !methodNames.isEmpty()){
				//mp.copy(objectToClone, methodNames);
			}
			else{
				mp.copy(objectToClone);	
			}
			
			
		}else{
			
			throw new IllegalStateException("Cloned object must be instance of "+ModelProxy.class);
			
		}
		
	}
	
}
