/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.Field;

public class ObservableManager<T> {
	
	private static ObservableManager instance;
	
	private HashMap<T,HashMap<String,List<MethodObserver<T>>>> specificMethodObservers;
	private HashMap<T,List<MethodObserver<T>>> genericObservers;
	
	static{
		instance = new ObservableManager();
	}
	
	
	private ObservableManager(){
		specificMethodObservers = new HashMap<T, HashMap<String,List<MethodObserver<T>>>>();
		genericObservers		= new HashMap<T, List<MethodObserver<T>>>();
	}

	/**
	 * Add an observer on a specific method
	 * @param observable
	 * @param methodName
	 * @param observer
	 */
	public void addMethodObserver(T observable,String methodName,MethodObserver<T> observer){
		
		HashMap<String,List<MethodObserver<T>>> observersByMethodName  		= this.specificMethodObservers.get(observable);
		
		if (observersByMethodName==null){
			observersByMethodName 	= new HashMap<String, List<MethodObserver<T>>>();
		}
		
		List<MethodObserver<T>> observers = observersByMethodName.get(methodName); 
		
		if (observers==null){
			observers = new ArrayList<MethodObserver<T>>();
		}
		
		observers.add(observer);
		
		observersByMethodName.put(methodName, observers);
		
		this.specificMethodObservers.put(observable, observersByMethodName);
	}
	
	
	public void addMethodObserverIfNoObserverExists(T observable,String methodName,MethodObserver<T> observer){
		
		if (specificMethodObservers.containsKey(observable)==false){
			addMethodObserver(observable, methodName, observer);
		}
		
	}
	
	/**
	 * Add an observer on every method
	 * @param observable
	 * @param observer
	 */
	public void addMethodObserver(T observable,MethodObserver<T> observer){
		
		List<MethodObserver<T>> observers = genericObservers.get(observable);
		
		if (observers==null){
			
			observers = new ArrayList<MethodObserver<T>>();
			
		}
		
		observers.add(observer);
		
		genericObservers.put(observable, observers);
	}
	

	public List<MethodObserver<T>> getMethodObservers(T observable,String methodName){
		
		HashMap<String,List<MethodObserver<T>>> observersByMethodName  = this.specificMethodObservers.get(observable);
		
		if (observersByMethodName!=null){
		List<MethodObserver<T>> observers = observersByMethodName.get(methodName);
		
		return observers;
		
		}else{
			return null;
		}
		
		
	}
	
	public List<MethodObserver<T>> getMethodObservers(T observable){
		return genericObservers.get(observable);
	}	
	
	
	public Field getFieldByName(T model,String fieldName){
		
		ModelProxy modelProxy = (ModelProxy) model;
		
		return  modelProxy.getFields().get(fieldName);		
	}
	
	
	public static ObservableManager getInstance(){
		return instance;
	}
	
}
