/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test;

import com.google.gwt.autobean.shared.AutoBean;
import com.google.gwt.autobean.shared.AutoBeanCodex;
import com.google.gwt.autobean.shared.AutoBeanFactory;
import com.google.gwt.autobean.shared.AutoBeanUtils;
import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import java.util.ArrayList;
import java.util.List;

public class AutoBeanTestGwt
extends GWTTestCase {
    public String getModuleName() {
        return "com.ebmwebsourcing.geasytools.modeleditor.modelmanager.ModelManager";
    }

    public void testAutoBean() {
        DoSomething doSomething = new DoSomething();
        Person p = doSomething.makePerson();
        p.setName("toto");
        p.getAddress().get(0).setRoad("4 Rue Am\u00e9lie");
        System.out.println("name:" + p.getName());
        System.out.println("adress:" + p.getAddress().get(0).getRoad());
        System.out.println("person type:" + p.getClass());
        System.out.println("person to string:" + p);
        AutoBean pauto = AutoBeanUtils.getAutoBean((Object)p);
        AutoBean pautoclone = pauto.clone(true);
        System.out.println("person clone to string:" + pautoclone.as());
        String json1 = doSomething.serializeToJson(p);
        String json2 = doSomething.serializeToJson((Person)pautoclone.as());
        System.out.println("person 1 serialization:" + json1);
        System.out.println("person 2 serialization:" + json2);
        Person pClone = doSomething.deserializeFromJson(json1);
        System.out.println("person clone (from JSON) to string:" + pClone);
    }

    public class DoSomething {
        MyFactory factory = (MyFactory)GWT.create(MyFactory.class);

        Person makePerson() {
            AutoBean<Person> person = this.factory.person();
            Person p = (Person)person.as();
            p.addAdress(new Address(){

                @Override
                public String getRoad() {
                    return null;
                }

                @Override
                public void setRoad(String road) {
                }
            });
            return p;
        }

        String serializeToJson(Person person) {
            AutoBean bean = AutoBeanUtils.getAutoBean((Object)person);
            return AutoBeanCodex.encode((AutoBean)bean).getPayload();
        }

        Person deserializeFromJson(String json) {
            AutoBean bean = AutoBeanCodex.decode((AutoBeanFactory)this.factory, Person.class, (String)json);
            return (Person)bean.as();
        }
    }

    @AutoBeanFactory.Category(value={PersonCategory.class})
    static interface MyFactory
    extends AutoBeanFactory {
        public AutoBean<Person> person();
    }

    class PersonImpl
    implements Person {
        private List<Address> addresses = new ArrayList<Address>();
        private String name;

        @Override
        public List<Address> getAddress() {
            return this.addresses;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setAddress(List<Address> address) {
            this.addresses = address;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void addAdress(Address address) {
            this.addresses.add(address);
        }
    }

    static interface Address {
        public String getRoad();

        public void setRoad(String var1);
    }

    public static class PersonCategory {
        public static void addAdress(AutoBean<Person> instance, Address address) {
            Person p = (Person)instance.as();
            if (p.getAddress() == null) {
                p.setAddress(new ArrayList<Address>());
            }
            p.getAddress().add(address);
        }
    }

    static interface Person {
        public List<Address> getAddress();

        public String getName();

        public void setName(String var1);

        public void setAddress(List<Address> var1);

        public void addAdress(Address var1);
    }
}

