/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.HistoryManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DumDumModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DummyModel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;

public class ModelHistoryManagerTestGwt
extends GWTTestCase {
    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
    }

    public String getModuleName() {
        return "com.ebmwebsourcing.geasytools.modeleditor.modelmanager.ModelManager";
    }

    public void testUndo() {
        System.out.println("---------- TESTING UNDO ----------");
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        HistoryManager historyManager = HistoryManager.getInstance();
        System.out.println("state 0 ==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.setString1("state1");
        System.out.println("state 1==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state1", (String)model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state 1==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.setString1("state2");
        System.out.println("state 2==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state2", (String)model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state 2==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.addDummyModel(new DummyModel());
        System.out.println("state 3==> dummyModels size:" + model.getDummyModels().size());
        ModelHistoryManagerTestGwt.assertEquals((int)1, (int)model.getDummyModels().size());
        historyManager.undo((Object)model);
        System.out.println("undo state 3==> dummyModels size:" + model.getDummyModels().size());
        ModelHistoryManagerTestGwt.assertEquals((int)0, (int)model.getDummyModels().size());
        model.setDummyModel(new DummyModel());
        System.out.println("model state 4 ==> dummyModel :" + model.getDummyModel().getString1());
        DummyModel model2 = model.getDummyModel();
        model2.setString1("changestate");
        model.setDummyModel(model2);
        System.out.println("model state 5==> dummyModel :" + model.getDummyModel().getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state 5==> dummyModel :" + model.getDummyModel().getString1());
    }

    public void testUndoThanAddRemovesPreviousEntriesToHistory() {
        System.out.println("----------------UndoThanAddRemovesPreviousEntriesToHistory----------------");
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        HistoryManager historyManager = HistoryManager.getInstance();
        System.out.println("state 0 ==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.setString1("state1");
        System.out.println("state 1==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state1", (String)model.getString1());
        model.setString1("state2");
        System.out.println("state 2==>" + model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state2 =>" + model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state1 =>" + model.getString1());
        model.setString1("state3");
        System.out.println("state 3==>" + model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state3 =>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state0", (String)model.getString1());
    }

    public void testUndoRedoWithList() {
        System.out.println("---------- TESTING UNDO WITH LIST ----------");
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        HistoryManager historyManager = HistoryManager.getInstance();
        model.setString1("toto");
        System.out.println("==>state1 :\n" + model);
        model.setString2("tata");
        System.out.println("==>state2 :\n" + model);
        model.addDummyModel(new DummyModel());
        System.out.println("==>state3 :\n" + model);
        historyManager.undo((Object)model);
        System.out.println("==>Undo state 3 :\n" + model);
        historyManager.redo((Object)model);
        System.out.println("==>Redo state 3 :\n" + model);
        model.addDummyModel(new DummyModel());
        System.out.println("==>state 4 :\n" + model);
        historyManager.undo((Object)model);
        System.out.println("==>Undo state 4 :\n" + model);
    }

    public void testRedo() {
        System.out.println("---------- TESTING REDO ----------");
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        HistoryManager historyManager = HistoryManager.getInstance();
        System.out.println("state 0 ==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.setString1("state1");
        System.out.println("state 1==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state1", (String)model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state 1==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state0", (String)model.getString1());
        historyManager.redo((Object)model);
        System.out.println("redo state 1==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state1", (String)model.getString1());
    }

    public void testHasMoreUndo() {
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        HistoryManager historyManager = HistoryManager.getInstance();
        model.setString1("state1");
        boolean hasMoreUndo1 = historyManager.hasMoreUndo((Object)model);
        ModelHistoryManagerTestGwt.assertEquals((boolean)true, (boolean)hasMoreUndo1);
        HistoryManager.getInstance().undo((Object)model);
        boolean hasMoreUndo2 = historyManager.hasMoreUndo((Object)model);
        ModelHistoryManagerTestGwt.assertEquals((boolean)false, (boolean)hasMoreUndo2);
        model.setString1("state2");
        HistoryManager.getInstance().undo((Object)model);
        boolean hasMoreUndo3 = historyManager.hasMoreUndo((Object)model);
        ModelHistoryManagerTestGwt.assertTrue((!hasMoreUndo3 ? 1 : 0) != 0);
        try {
            historyManager.undo((Object)model);
        }
        catch (Exception e) {
            boolean isIllegalStateException = e instanceof IllegalStateException;
            ModelHistoryManagerTestGwt.assertEquals((boolean)true, (boolean)isIllegalStateException);
        }
    }

    public void testHasMoreRedo() {
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        HistoryManager historyManager = HistoryManager.getInstance();
        System.out.println("state 0 ==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state0", (String)model.getString1());
        model.setString1("state1");
        System.out.println("state 1==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state1", (String)model.getString1());
        historyManager.undo((Object)model);
        System.out.println("undo state 1==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state0", (String)model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((boolean)true, (boolean)historyManager.hasMoreRedo((Object)model));
        historyManager.redo((Object)model);
        System.out.println("redo state 1==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state1", (String)model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((boolean)false, (boolean)historyManager.hasMoreRedo((Object)model));
        model.setString1("state2");
        System.out.println("state 2==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((boolean)false, (boolean)historyManager.hasMoreRedo((Object)model));
        historyManager.undo((Object)model);
        System.out.println("undo state 2==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state1", (String)model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((boolean)true, (boolean)historyManager.hasMoreRedo((Object)model));
        historyManager.redo((Object)model);
        System.out.println("redo state 2==>" + model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((String)"state2", (String)model.getString1());
        ModelHistoryManagerTestGwt.assertEquals((boolean)false, (boolean)historyManager.hasMoreRedo((Object)model));
        try {
            historyManager.redo((Object)model);
        }
        catch (Exception e) {
            boolean isIllegalStateException = e instanceof IllegalStateException;
            ModelHistoryManagerTestGwt.assertEquals((boolean)true, (boolean)isIllegalStateException);
        }
    }

    public void testUnBindedModel() {
        DumDumModel dumdum = (DumDumModel)GWT.create(DumDumModel.class);
        HistoryManager historyManager = HistoryManager.getInstance();
        dumdum.setString1("state1");
        try {
            historyManager.undo((Object)dumdum);
        }
        catch (Exception e) {
            boolean isIllegalStateException = e instanceof IllegalStateException;
            ModelHistoryManagerTestGwt.assertEquals((boolean)true, (boolean)isIllegalStateException);
        }
    }
}

