/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.MethodObserver;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.ObservableManager;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DumDumModel;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.test.DummyListModel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.junit.client.GWTTestCase;
import junit.framework.Assert;

public class ObservableManagerTestGwt
extends GWTTestCase {
    private static boolean beforeMethodObserver = false;
    private static boolean afterMethodObserver = false;
    private String assignedString;
    private int expectedListSize;
    private Double doubleParameter;

    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
    }

    public String getModuleName() {
        return "com.ebmwebsourcing.geasytools.modeleditor.modelmanager.ModelManager";
    }

    public void testSimpleMethodObserver() {
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        ObservableManager observerbleManager = ObservableManager.getInstance();
        observerbleManager.addMethodObserver((Object)model, "setString2", (MethodObserver)new MethodObserver<DumDumModel>(){

            public void beforeMethodCalled(DumDumModel model, Object ... parameters) {
                System.out.println("model1 before setString2 is invoked");
                beforeMethodObserver = true;
            }

            public void afterMethodCalled(DumDumModel model, Object ... parameters) {
                System.out.println("model1 after setString2 is invoked");
                afterMethodObserver = true;
            }
        });
        ObservableManagerTestGwt.assertFalse((boolean)beforeMethodObserver);
        ObservableManagerTestGwt.assertFalse((boolean)afterMethodObserver);
        System.out.println("invoking setString2 from model1");
        model.setString2("state1");
        ObservableManagerTestGwt.assertTrue((boolean)beforeMethodObserver);
        ObservableManagerTestGwt.assertTrue((boolean)afterMethodObserver);
        beforeMethodObserver = false;
        afterMethodObserver = false;
        DumDumModel model2 = (DumDumModel)GWT.create(DumDumModel.class);
        observerbleManager.addMethodObserver((Object)model2, "setString2", (MethodObserver)new MethodObserver<DumDumModel>(){

            public void beforeMethodCalled(DumDumModel model, Object ... parameters) {
                System.out.println("model2 before setString2 is invoked");
                beforeMethodObserver = true;
            }

            public void afterMethodCalled(DumDumModel model, Object ... parameters) {
                System.out.println("model2 before setString2 is invoked");
                afterMethodObserver = true;
            }
        });
        ObservableManagerTestGwt.assertFalse((boolean)beforeMethodObserver);
        ObservableManagerTestGwt.assertFalse((boolean)afterMethodObserver);
        System.out.println("invoking setString2 from model2");
        model2.setString2("state1");
        ObservableManagerTestGwt.assertTrue((boolean)beforeMethodObserver);
        ObservableManagerTestGwt.assertTrue((boolean)afterMethodObserver);
        beforeMethodObserver = false;
        afterMethodObserver = false;
        observerbleManager.addMethodObserver((Object)model2, (MethodObserver)new MethodObserver<DumDumModel>(){

            public void beforeMethodCalled(DumDumModel model, Object ... parameters) {
                beforeMethodObserver = true;
            }

            public void afterMethodCalled(DumDumModel model, Object ... parameters) {
                afterMethodObserver = true;
            }
        });
        model2.setString1("ss");
        ObservableManagerTestGwt.assertTrue((boolean)beforeMethodObserver);
        ObservableManagerTestGwt.assertTrue((boolean)afterMethodObserver);
        beforeMethodObserver = false;
        afterMethodObserver = false;
        model2.setString2("ee");
        ObservableManagerTestGwt.assertTrue((boolean)beforeMethodObserver);
        ObservableManagerTestGwt.assertTrue((boolean)afterMethodObserver);
    }

    public void testMethodObserverWithParams() {
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        ObservableManager observerbleManager = ObservableManager.getInstance();
        observerbleManager.addMethodObserver((Object)model, "setString2", (MethodObserver)new MethodObserver<DumDumModel>(){

            public void afterMethodCalled(DumDumModel model, Object ... parameters) {
                Assert.assertNotNull((Object)parameters);
                Assert.assertEquals((int)1, (int)parameters.length);
                Assert.assertEquals((Object)ObservableManagerTestGwt.this.assignedString, (Object)parameters[0]);
                Assert.assertEquals((String)ObservableManagerTestGwt.this.assignedString, (String)model.getString2());
            }

            public void beforeMethodCalled(DumDumModel model, Object ... parameters) {
                Assert.assertNotNull((Object)parameters);
                Assert.assertEquals((int)1, (int)parameters.length);
                Assert.assertEquals((Object)ObservableManagerTestGwt.this.assignedString, (Object)parameters[0]);
            }
        });
        this.assignedString = "test1";
        model.setString2(this.assignedString);
    }

    public void testMethodObserverAddRemove() {
        DummyListModel model = (DummyListModel)GWT.create(DummyListModel.class);
        ObservableManager observerbleManager = ObservableManager.getInstance();
        observerbleManager.addMethodObserver((Object)model, "addNewElement", (MethodObserver)new MethodObserver<DummyListModel>(){

            public void beforeMethodCalled(DummyListModel model, Object ... parameters) {
                Assert.assertNotNull((Object)parameters);
                Assert.assertEquals((int)1, (int)parameters.length);
                Assert.assertEquals((Object)ObservableManagerTestGwt.this.doubleParameter, (Object)parameters[0]);
            }

            public void afterMethodCalled(DummyListModel model, Object ... parameters) {
                Assert.assertNotNull((Object)parameters);
                Assert.assertEquals((int)1, (int)parameters.length);
                Assert.assertEquals((Object)ObservableManagerTestGwt.this.doubleParameter, (Object)parameters[0]);
                Assert.assertEquals((int)ObservableManagerTestGwt.this.expectedListSize, (int)model.getList().size());
            }
        });
        observerbleManager.addMethodObserver((Object)model, "remove", (MethodObserver)new MethodObserver<DummyListModel>(){

            public void beforeMethodCalled(DummyListModel model, Object ... parameters) {
                Assert.assertNotNull((Object)parameters);
                Assert.assertEquals((int)1, (int)parameters.length);
                Assert.assertEquals((Object)ObservableManagerTestGwt.this.doubleParameter, (Object)parameters[0]);
            }

            public void afterMethodCalled(DummyListModel model, Object ... parameters) {
                Assert.assertNotNull((Object)parameters);
                Assert.assertEquals((int)1, (int)parameters.length);
                Assert.assertEquals((Object)ObservableManagerTestGwt.this.doubleParameter, (Object)parameters[0]);
                Assert.assertEquals((int)ObservableManagerTestGwt.this.expectedListSize, (int)model.getList().size());
            }
        });
        this.expectedListSize = 1;
        this.doubleParameter = new Double(27.0);
        model.addNewElement(this.doubleParameter);
        this.expectedListSize = 2;
        this.doubleParameter = new Double(52.0);
        model.addNewElement(this.doubleParameter);
        this.expectedListSize = 1;
        this.doubleParameter = new Double(27.0);
        model.remove(this.doubleParameter);
    }

    public void testMultipleObserversOnSingleModel() {
        DumDumModel model = (DumDumModel)GWT.create(DumDumModel.class);
        ObservableManager observerbleManager = ObservableManager.getInstance();
        observerbleManager.addMethodObserver((Object)model, (MethodObserver)new MethodObserver<DumDumModel>(){

            public void afterMethodCalled(DumDumModel model, Object ... parameters) {
                System.out.println("Observer1");
            }

            public void beforeMethodCalled(DumDumModel model, Object ... parameters) {
            }
        });
        observerbleManager.addMethodObserver((Object)model, (MethodObserver)new MethodObserver<DumDumModel>(){

            public void afterMethodCalled(DumDumModel model, Object ... parameters) {
                System.out.println("Observer2");
            }

            public void beforeMethodCalled(DumDumModel model, Object ... parameters) {
            }
        });
        model.setString1("hello1");
        model.setString1("hello2");
    }
}

