/**
 * webeditor-api - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.api.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.IContentPanelComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.IQualifiedName;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IPlugin;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.IProjectPlugin;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditConfigurationPanel;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;


public interface IEditorRegistry {

	HashMap<IQualifiedName,IComponent> getRegisteredComponents();
	
	IProjectPlugin getProjectPlugin(IProjectType projectType);
	
	void registerComponent(IComponent component);
	
	IComponent getComponentByQualifiedName(IQualifiedName qname);
	
	void registerPlugins(HashSet<IPlugin> plugins);
	
	HashSet<IComponent> getAssociatedComponents(IContentPanelComponent component);

	/**
	 * Register the associated components of a ContentPanelComponent
	 */
	void registerComponent(IContentPanelComponent component, HashSet<IComponent> components);
	
	List<IProjectType> getAvailableProjectsType();
	
	void registerEditConfigurationPanels(IProjectInstance instance, List<IEditConfigurationPanel> panels);
	
	List<IEditConfigurationPanel> getEditConfigurationPanelsByProjectInstance(IProjectInstance instance);
	
	IContentPanelComponent getContentPanelComponent(IProjectInstance instance);
	
	/**
	 * Returns every components associated to every content panel
	 * @return
	 */
	HashSet<IComponent> getAllContentPanelsComponents();
	
}
