/**
 * webeditor-domain - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.webeditor.impl.domain.project;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

import com.ebmwebsourcing.webeditor.api.domain.project.IDefaultProjectConfigurationData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectConfigurationData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectGroup;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.api.domain.user.IUser;

public abstract class ProjectInstance implements IProjectInstance {


	private IProjectType projectType;
	private String name;
	private IUser author;
	private String id;
	private Date creationDate;
	private Date lastModifDate;
	private IProjectInstanceMetaData exportMetadata;
	private IProjectInstanceMetaData importMetadata;
	private HashSet<IProjectGroup> projectGroups;
	private List<IProjectInstanceMetaData> medaDatas;
	private boolean isPublic;
	private boolean autosave;
	
	public ProjectInstance() {
		this.projectGroups 	= new HashSet<IProjectGroup>();
		this.medaDatas 		= new ArrayList<IProjectInstanceMetaData>();
		this.creationDate   = new Date();
		this.lastModifDate 	= new Date();
	}
	
	public void setPublic(boolean ispublic) {
		this.isPublic = ispublic;
	};
	
	@Override
	public void setAutoSave(boolean autosave) {
		this.autosave = autosave;
	}
	
	@Override
	public boolean isAutoSave() {
		return autosave;
	}
	
	@Override
	public boolean isPublic() {
		return isPublic;
	}
	
	@Override
	public IUser getAuthor() {
		return author;
	}

	@Override
	public Date getCreationDate() {
		return creationDate;
	}

	@Override
	public Date getLastModificationDate() {
		return lastModifDate;
	}

	@Override
	public void setLastModificationDate(Date lastModifDate) {
		this.lastModifDate = lastModifDate;
	}

	@Override
	public IProjectInstanceMetaData getExportData() {
		return exportMetadata;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public IProjectInstanceMetaData getImportData() {
		return importMetadata;
	}

	@Override
	public String getName() {
		return name;
	}
	
	@Override
	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public HashSet<IProjectGroup> getProjectGroups() {
		return this.projectGroups;
	}

	@Override
	public IProjectType getProjectType() {
		return projectType;
	}

	@Override
	public void setAuthor(IUser author) {
		this.author = author;
	}

	@Override
	public void setType(IProjectType type) {
		this.projectType = type;
	}
	
	public void setId(String id) {
		this.id = id;
	}

	@Override
	public boolean equals(Object obj) {
	    if(obj==null || !(obj instanceof IProjectInstance)) {
	        return false;
	    }
		return ((IProjectInstance)obj).getId().equals(this.getId());
	}
	
	@Override
	public int hashCode() {
		return this.getId().hashCode();
	}
	
	@Override
	public void addMetadata(IProjectInstanceMetaData metaData) {
		this.medaDatas.add(metaData);
	}
	
	@Override
	public List<IProjectInstanceMetaData> getMetaDatas() {
		return medaDatas;
	}
	
	@Override
	public void bind(IProjectConfigurationData data) {
		//default binding
		if (data instanceof IDefaultProjectConfigurationData){
			IDefaultProjectConfigurationData d = (IDefaultProjectConfigurationData) data;
			
			this.setName(d.getProjectName());
			this.setPublic(d.isPublic());
			this.setAutoSave(d.isAutoSave());
		}
	}
	
}
