/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter;

import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IOpenProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IOpenProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.AbstractCommonPresentersTest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter.OpenProjectPresenter;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFileSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IFinishEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.File;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FilesSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.wizard.event.FinishEvent;
import com.google.gwt.event.shared.GwtEvent;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import net.customware.gwt.presenter.client.place.PlaceParsingException;
import net.customware.gwt.presenter.client.place.PlaceRequest;
import net.customware.gwt.presenter.client.place.PlaceRequestEvent;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Before;
import org.junit.Test;

public class OpenProjectPresenterTest
extends AbstractCommonPresentersTest {
    private IOpenProjectConfigurationView displayMock;
    private OpenProjectPresenter presenter;
    private IFileExplorerPanelHandler fileExplorerHandler;
    private boolean configurationCompleteCalled = false;

    @Before
    public void initMocksAndExpectations() {
        this.displayMock = (IOpenProjectConfigurationView)EasyMock.createMock(IOpenProjectConfigurationView.class);
        EasyMock.expect((Object)this.displayMock.getFileExplorerPanel()).andReturn((Object)this.fileExplorerPanelMock).anyTimes();
        EasyMock.expect((Object)this.displayMock.getWizard()).andReturn((Object)this.wizardMock).anyTimes();
        this.displayMock.setAvailableProjectTypes((List)EasyMock.isA(List.class));
        EasyMock.replay((Object[])new Object[]{this.displayMock});
        this.fileExplorerPanelMock.addHandler((IFileExplorerPanelHandler)EasyMock.isA(IFileExplorerPanelHandler.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                Object[] args = EasyMock.getCurrentArguments();
                OpenProjectPresenterTest.this.fileExplorerHandler = (IFileExplorerPanelHandler)args[0];
                return null;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.fileExplorerPanelMock});
        this.presenter = new OpenProjectPresenter(this.displayMock, this.eventBus);
        this.presenter.bind();
    }

    @Test
    public void testHasAvailableProjectTypesOnLoad_AndDisplaysOnView() {
        Assert.assertEquals((Object)this.projectTypes, (Object)this.presenter.getAvailableProjectTypes());
        EasyMock.verify((Object[])new Object[]{this.displayMock});
    }

    @Test
    public void testRequestOnPlaceOpensDisplay() throws PlaceParsingException {
        EasyMock.reset((Object[])new Object[]{this.displayMock});
        this.displayMock.open();
        EasyMock.replay((Object[])new Object[]{this.displayMock});
        String req = OpenProjectPresenter.PLACE.getId();
        this.eventBus.fireEvent((GwtEvent)new PlaceRequestEvent(PlaceRequest.fromString((String)req)));
        EasyMock.verify((Object[])new Object[]{this.displayMock});
    }

    @Test
    public void testProjectTypeSelection_DisplaysAssociatedFiles() {
        EasyMock.reset((Object[])new Object[]{this.displayMock});
        this.displayMock.setProjectFiles((List)EasyMock.isA(List.class));
        EasyMock.replay((Object[])new Object[]{this.displayMock});
        this.fileExplorerHandler.onFolderSelected((IFolderSelectedEvent)new FolderSelectedEvent(this.folderMock));
        Assert.assertEquals((Object)this.projectFiles, (Object)this.presenter.getCurrentProjectFiles());
        EasyMock.verify((Object[])new Object[]{this.displayMock});
    }

    @Test
    public void testProjectFileSelection_AndClickOnFinish_FiresOpenProjectConfigurationCompleteEvent() {
        EasyMock.reset((Object[])new Object[]{this.displayMock});
        this.displayMock.setProjectFiles((List)EasyMock.isA(List.class));
        EasyMock.expectLastCall().anyTimes();
        this.displayMock.close();
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.displayMock});
        this.fileExplorerHandler.onFolderSelected((IFolderSelectedEvent)new FolderSelectedEvent(this.folderMock));
        File file1 = new File();
        file1.setAttribute("projectFile", this.projectFiles.get(0));
        File file2 = new File();
        file2.setAttribute("projectFile", this.projectFiles.get(1));
        HashSet<File> selectedFiles = new HashSet<File>();
        selectedFiles.add(file1);
        selectedFiles.add(file2);
        this.fileExplorerHandler.onFilesSelected((IFileSelectedEvent)new FilesSelectedEvent(selectedFiles));
        this.eventBus.addProjectConfigurationHandler(new IProjectConfigurationHandler(){

            public void onConfigurationComplete(IProjectConfigurationCompleteEvent event) {
                if (event instanceof IOpenProjectConfigurationCompleteEvent) {
                    IOpenProjectConfigurationCompleteEvent e = (IOpenProjectConfigurationCompleteEvent)event;
                    Assert.assertNotNull((Object)e.getProjectType());
                    Assert.assertNotNull((Object)e.getProjectIds());
                    OpenProjectPresenterTest.this.configurationCompleteCalled = true;
                }
            }
        });
        this.wizardHandler.onFinish((IFinishEvent)new FinishEvent());
        Assert.assertTrue((boolean)this.configurationCompleteCalled);
        EasyMock.verify((Object[])new Object[]{this.displayMock});
    }
}

