/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events;

import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IContentPanelComponentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IContentPanelComponentUpdateEvent;
import com.google.gwt.event.shared.GwtEvent;

public class ContentComponentPanelUpdateEvent extends GwtEvent<IContentPanelComponentHandler> implements IContentPanelComponentUpdateEvent{
	
	private String title;
	
	public static Type<IContentPanelComponentHandler> TYPE = new Type<IContentPanelComponentHandler>();
	
	public ContentComponentPanelUpdateEvent(String title) {
		this.title = title;
	}
	
	@Override
	protected void dispatch(IContentPanelComponentHandler handler) {
		handler.onUpdate(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IContentPanelComponentHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public String getTitle() {
		return title;
	}



}
