/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core;

import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorView;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.ILayout;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractEditorView extends Composite implements IEditorView{
	
	private ILayout layout;
	
	public AbstractEditorView() {
		this.layout = this.getDefaultLayout();
		initWidget(getMainWidget());
	}
	
	@Override
	public void close() {
		this.getMainWidget().removeFromParent();
	}

	@Override
	public void setLayout(ILayout layout) {
		this.layout = layout;
	}

	@Override
	public ILayout getLayout() {
		return layout;
	}
	
	public abstract Widget getMainWidget();
	
	protected abstract ILayout getDefaultLayout();
	
}
