/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.project;

import gwtupload.client.IUploader;
import gwtupload.client.IUploader.OnFinishUploaderHandler;
import gwtupload.client.IUploader.OnStartUploaderHandler;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IContentPanelComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.DefaultErrorLevel;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.project.IDefaultRequestProjectHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IProjectManager;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IGetActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IGetAvailableProjectTypesRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IGetOpenedProjectInstancesRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IGetProjectFilesByTypeRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IGetProjectInstanceByIdRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IGetProjectInstanceByURLRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.ISaveProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IUploadMetaDataRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IValidateActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetAvailableProjectTypesResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetOpenedProjectInstancesResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetProjectFilesByTypeResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetProjectInstanceByIdResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetProjectInstanceByURLResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.ISaveProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IUploadMetaDataRequestResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IValidateActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequestEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.upload.IUploadWindow;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.DisableLoadingStateEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.EditorErrorEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.EnableLoadingStateEvent;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.api.domain.project.ProjectValidationException;
import com.ebmwebsourcing.webeditor.client.impl.service.GwtProjectServiceAsync;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class DefaultRequestResponseProjectHandler implements IDefaultRequestProjectHandler{

	private IProjectManager projectManager;
	private GwtProjectServiceAsync projectService;

	public DefaultRequestResponseProjectHandler(IProjectManager projectManager) {
		this.projectManager = projectManager;
		this.projectService = (GwtProjectServiceAsync) projectManager.getServiceFactory().getProjectService();
	}


	@Override
	public IProjectManager getProjectManager() {
		return projectManager;
	}


	@Override
	public void onRequest(IRequestEvent event) {

		if (event.getRequest() instanceof IGetActualProjectInstanceRequest){

			IGetActualProjectInstanceResponseHandler resH = (IGetActualProjectInstanceResponseHandler) event.getResponseHandler();

			resH.receiveResponse(projectManager.getActualProjectInstance());

		}else if (event.getRequest() instanceof IGetAvailableProjectTypesRequest){
			//GET AVAILABLE PROJECT TYPE

			IGetAvailableProjectTypesResponseHandler res 	= (IGetAvailableProjectTypesResponseHandler) event.getResponseHandler();

			List<IProjectType> availableProjectTypes   		= projectManager.getFrontController().getRegistry().getAvailableProjectsType();

			res.receiveResponse(availableProjectTypes);


		}else if (event.getRequest() instanceof IGetOpenedProjectInstancesRequest){	
			//GET OPENED PROJECT INSTANCES	

			IGetOpenedProjectInstancesResponseHandler res = (IGetOpenedProjectInstancesResponseHandler) event.getResponseHandler();

			//retrieve every instances
			List<IProjectInstance> instances = new ArrayList<IProjectInstance>();

			List<IContentPanelComponent> components = projectManager.getFrontController().getComponentDispatcher().getOpenedContentPanelComponent();

			for(IContentPanelComponent component:components){

				instances.add(component.getProjectInstance());

			}

			res.receiveResponse(instances);




		}else if (event.getRequest() instanceof IGetProjectFilesByTypeRequest){
			//GET PROJECT FILES BY TYPE


			IGetProjectFilesByTypeRequest req = (IGetProjectFilesByTypeRequest) event.getRequest();

			final IGetProjectFilesByTypeResponseHandler res = (IGetProjectFilesByTypeResponseHandler) event.getResponseHandler();

			//enable loading state
			projectManager.getEventBus().fireEvent(new EnableLoadingStateEvent("Loading project types, please wait..."));

			projectService.getProjectFilesByProjectType(req.getProjectType(), new AsyncCallback<List<IProjectFile>>() {

				@Override
				public void onSuccess(List<IProjectFile> result) {

					res.receiveResponse(result);

					projectManager.getEventBus().fireEvent(new DisableLoadingStateEvent());

				}

				@Override
				public void onFailure(Throwable caught) {

					projectManager.getEventBus().fireEvent(new EditorErrorEvent("Project Service Error", caught.getMessage(),DefaultErrorLevel.ERROR));

				}
			});


		}else if (event.getRequest() instanceof ISaveProjectInstanceRequest){
			//SAVE PROJECT INSTANCE 

			final ISaveProjectInstanceRequest req = (ISaveProjectInstanceRequest) event.getRequest();
			final ISaveProjectInstanceResponseHandler res = (ISaveProjectInstanceResponseHandler) event.getResponseHandler();

			//enable loading state
			projectManager.getEventBus().fireEvent(new EnableLoadingStateEvent("Saving project, please wait..."));			

			projectService.saveProjectInstance(req.getProjectInstance(), new AsyncCallback<Void>() {
				@Override
				public void onSuccess(Void result) {
					res.receiveResponse(result);

					//mark actual component as saved
					IContentPanelComponent component = projectManager.getFrontController().getRegistry().getContentPanelComponent(req.getProjectInstance());
					projectManager.getFrontController().getContentManager().markContentPanelSaved(component);

					projectManager.getEventBus().fireEvent(new DisableLoadingStateEvent());
				}

				@Override
				public void onFailure(Throwable caught) {
					projectManager.getEventBus().fireEvent(new EditorErrorEvent("Project Service Error", caught.getMessage(),DefaultErrorLevel.ERROR));
				}

			});		


		} else if (event.getRequest() instanceof IGetProjectInstanceByIdRequest){
			//GET PROJECT INSTANCE BY ID

			IGetProjectInstanceByIdRequest req = (IGetProjectInstanceByIdRequest) event.getRequest();

			final IGetProjectInstanceByIdResponseHandler res = (IGetProjectInstanceByIdResponseHandler) event.getResponseHandler();

			//enable loading state
			projectManager.getEventBus().fireEvent(new EnableLoadingStateEvent("Searching for project with id"+req.getId()+", please wait..."));			

			projectService.getProjectInstanceById(req.getId(), new AsyncCallback<IProjectInstance>() {

				public void onSuccess(IProjectInstance result) {

					res.receiveResponse(result);

					projectManager.getEventBus().fireEvent(new DisableLoadingStateEvent());



				};

				@Override
				public void onFailure(Throwable caught) {

					projectManager.getEventBus().fireEvent(new EditorErrorEvent("Project Service Error", caught.getMessage(),DefaultErrorLevel.ERROR));
				}

			});


		}else if (event.getRequest() instanceof IUploadMetaDataRequest){

			//first check if actual project instance is saved

			final IUploadMetaDataRequest req = (IUploadMetaDataRequest) event.getRequest(); 
			final IUploadMetaDataRequestResponseHandler res = (IUploadMetaDataRequestResponseHandler) event.getResponseHandler();

			//			IContentPanelComponent component = projectManager.getFrontController().getRegistry().getContentPanelComponent(req.getProjectInstance());

			//FIXME project instance cannot be saved before import are done
			//because a diagram might need information from its attachments
			//to be valid
			// So a solution might be to save the attached files in a temporary file
			//and to copy these files on the first save or export of the project instance
			processUploadMetaDataRequest(req, res);
			//			if (component.isSaved()==true){
			//				//if the stuff is already saved process upload
			//				processUploadMetaDataRequest(req,res);
			//			}else{
			//				//otherwise ask user to save
			//				projectManager.getEventBus().fireEvent(new ConfirmDialogEvent("Actual project not saved", "Actual project must be saved before uploading a file. Would you like to save project now ?", new IConfirmDialogCallBack() {
			//					@Override
			//					public void onConfirm(boolean confirm) {
			//						//user want to save => save and then process upload
			//						if (confirm){
			//							projectManager.getEventBus().fireEvent(new RequestEvent(new SaveProjectInstanceRequest(req.getProjectInstance()), new ISaveProjectInstanceResponseHandler() {
			//								@Override
			//								public void receiveResponse(IProjectFile result) {
			//									processUploadMetaDataRequest(req, res);
			//								}
			//							}));
			//						}
			//					}
			//				}));
			//			}


		}else if(event.getRequest() instanceof IValidateActualProjectInstanceRequest){

			IValidateActualProjectInstanceResponseHandler res = (IValidateActualProjectInstanceResponseHandler) event.getResponseHandler();

			ProjectValidationException exception = null;

			try {

				projectManager.getFrontController().getProjectManager().getActualContentPanel().validate();


			} catch (ProjectValidationException e) {

				exception = e;


			}finally{

				res.receiveResponse(exception);

			}

		}else if (event.getRequest() instanceof IGetProjectInstanceByURLRequest){

			IGetProjectInstanceByURLRequest req = (IGetProjectInstanceByURLRequest) event.getRequest();

			final IGetProjectInstanceByURLResponseHandler res = (IGetProjectInstanceByURLResponseHandler) event.getResponseHandler();

			projectManager.getEventBus().fireEvent(new EnableLoadingStateEvent("Loading project from URL, please wait..."));

			projectService.loadProjectInstanceByUrl(req.getURL(), req.getProjectType(), req.getFormat(), new AsyncCallback<IProjectInstance>() {

				public void onSuccess(IProjectInstance result) {

					res.receiveResponse(result);

					projectManager.getEventBus().fireEvent(new DisableLoadingStateEvent());



				};

				@Override
				public void onFailure(Throwable caught) {

					projectManager.getEventBus().fireEvent(new EditorErrorEvent("Project Service Error", caught.getMessage(),DefaultErrorLevel.ERROR));
				}


			});

		}


	}


	private void processUploadMetaDataRequest(final IUploadMetaDataRequest req,final IUploadMetaDataRequestResponseHandler res){


		//show upload window
		final IUploadWindow uploadWindow = projectManager.getFrontController().getView().getUploadWindow(); 
		uploadWindow.open();
		uploadWindow.setTitle(req.getTitle());
		uploadWindow.setMessage(req.getMessage());


		//enable loading state when upload starts
		uploadWindow.getUploader().addOnStartUploadHandler(new OnStartUploaderHandler() {

			@Override
			public void onStart(IUploader uploader) {

				projectManager.getEventBus().fireEvent(new EnableLoadingStateEvent("Uploading file, please wait..."));

			}
		});


		//when upload is complete attach file via service and send response, close upload window
		uploadWindow.getUploader().addOnFinishUploadHandler(new OnFinishUploaderHandler() {

			@Override
			public void onFinish(IUploader uploader) {

				String uploadRef = uploader.getInputName();

				projectService.addMetaData(uploadRef, req.getProjectInstance(), req.getFormat(), new AsyncCallback<IProjectInstanceMetaData>() {

					@Override
					public void onSuccess(IProjectInstanceMetaData result) {

						res.receiveResponse(result);

						uploadWindow.close();

						projectManager.getEventBus().fireEvent(new DisableLoadingStateEvent());

					}

					@Override
					public void onFailure(Throwable caught) {

						projectManager.getEventBus().fireEvent(new EditorErrorEvent("Project Service Error", caught.getMessage(),DefaultErrorLevel.ERROR));

					}
				});

			}
		});


	}


}
