/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager;

import com.ebmwebsourcing.geasytools.webeditor.api.core.IComponentDispatcher;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.component.IDefaultContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.component.IDefaultProjectConfigurationHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.component.IDefaultRequestComponentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IComponentManager;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IAddComponentEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IPanelChangeEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.component.DefaultContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.component.DefaultPluginHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.component.DefaultProjectConfigurationHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.component.DefaultRequestComponentHandler;
import com.google.gwt.event.shared.GwtEvent;

public class ComponentManager extends AbstractManager implements IComponentManager{
	
	private IDefaultProjectConfigurationHandler defaultProjectConfigurationHandler;
	private IDefaultContentPanelPlaceHolderHandler defaultContentPanelPlaceHolderHandler;
	private IDefaultRequestComponentHandler defaultRequestComponentHandler;
	
	public ComponentManager(IEditorFrontController controller) {
		super(controller);
		
	}

	@Override
	public IComponentDispatcher getComponentDispatcher() {		
		return getFrontController().getComponentDispatcher();
	}

	@Override
	public void handleProjectConfiguration() {
		
		getEventBus().addProjectConfigurationHandler(getDefaultProjectConfigurationHandler());
		
	}
	
	@Override
	public void handleContentPanelChange() {
		getFrontController().getView().getLayout().getMainContentPanelPlaceHolder().addHandler(getDefaultContentPanelPlaceHolderHandler());
		
	}
	
	
	@Override
	public IDefaultProjectConfigurationHandler getDefaultProjectConfigurationHandler() {
		
		if (defaultProjectConfigurationHandler==null){
			this.defaultProjectConfigurationHandler 	= new DefaultProjectConfigurationHandler(this);
		}
		
		
		return defaultProjectConfigurationHandler;
	}

	@Override
	public IDefaultContentPanelPlaceHolderHandler getDefaultContentPanelPlaceHolderHandler() {
		
		
		if (defaultContentPanelPlaceHolderHandler==null){
			this.defaultContentPanelPlaceHolderHandler	= new DefaultContentPanelPlaceHolderHandler(this);
		}
		
		return defaultContentPanelPlaceHolderHandler;
	}



	@Override
	public void bindEvents() {
//		
//		handleProjectConfiguration();
//		handleContentPanelChange();
		handleRequests();
		getEventBus().addPluginManagerHandler(new DefaultPluginHandler(this));
		forwardComponentsEvents();
		
		
	}

	@Override
	public void forwardComponentsEvents() {

		getFrontController().getView().getLayout().getMainContentPanelPlaceHolder().addHandler(new IContentPanelPlaceHolderHandler() {
			
			@Override
			public void onAddComponent(IAddComponentEvent event) {
				
				getEventBus().fireEvent((GwtEvent<?>) event);
				
			}
			
			@Override
			public void onPanelChange(IPanelChangeEvent event) {
				
				
				getEventBus().fireEvent((GwtEvent<?>) event);
				
			}
		});
			
			
		
	}

	@Override
	public IDefaultRequestComponentHandler getDefaultRequestComponenthandler() {
		
		if (this.defaultRequestComponentHandler==null){
			
			this.defaultRequestComponentHandler = new DefaultRequestComponentHandler(this);
			
		}
		
		return this.defaultRequestComponentHandler;
	}

	@Override
	public void handleRequests() {
		
		getEventBus().addRequestHandler(getDefaultRequestComponenthandler());
	
	}

}
