/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IContentPanelComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.project.IDefaultRequestProjectHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IProjectManager;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IAddComponentEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IContentPanelPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IPanelChangeEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.ISaveProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.project.DefaultRequestResponseProjectHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.SaveProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Event.NativePreviewEvent;
import com.google.gwt.user.client.Event.NativePreviewHandler;

public class ProjectManager extends AbstractManager implements IProjectManager{
	
	private IDefaultRequestProjectHandler defaultRequestResponseProjectHandler;
	private IProjectInstance actualProjectInstance;
	private IContentPanelComponent contentPanel;
	
	
	public ProjectManager(IEditorFrontController controller) {
		super(controller);
		
		
		//register save key shortcut
		NativePreviewHandler nph = new NativePreviewHandler() {
			@Override
			public void onPreviewNativeEvent(NativePreviewEvent event) {

				if (event.getTypeInt()==Event.ONKEYDOWN){
					if (event.getNativeEvent().getKeyCode()==83 && event.getNativeEvent().getCtrlKey()){

						if (getFrontController().getProjectManager().getActualProjectInstance()!=null){
							getEventBus().fireEvent(new RequestEvent(new SaveProjectInstanceRequest(getFrontController().getProjectManager().getActualProjectInstance()), new ISaveProjectInstanceResponseHandler() {
								@Override
								public void receiveResponse(Void result) {

								}
							}));
						}
						event.getNativeEvent().preventDefault(); //prevent browser save
					}
				}
			}
		}; 
		
		Event.addNativePreviewHandler(nph);
		

	}

	@Override
	public void handleRequests() {
		
		getEventBus().addRequestHandler(getDefaultRequestResponseProjectHandler());
		
	}


	@Override
	public IDefaultRequestProjectHandler getDefaultRequestResponseProjectHandler() {
		
		if (defaultRequestResponseProjectHandler==null){
			this.defaultRequestResponseProjectHandler = new DefaultRequestResponseProjectHandler(this); 
		}
		
		return defaultRequestResponseProjectHandler;
	
	}

	@Override
	public void bindEvents() {
		handleRequests();
		handleContentPanelPlaceHolderPanelChange();
	}

	@Override
	public void handleContentPanelPlaceHolderPanelChange() {
		
		getFrontController().getView().getLayout().getMainContentPanelPlaceHolder().addHandler(new IContentPanelPlaceHolderHandler() {
			
			@Override
			public void onAddComponent(IAddComponentEvent event) {
			
			
			}
			
			@Override
			public void onPanelChange(IPanelChangeEvent event) {
				contentPanel = event.getSelectedPanel();
				
				actualProjectInstance = event.getSelectedPanel().getProjectInstance();
				
			}
		});
		
	}

	@Override
	public IProjectInstance getActualProjectInstance() {
		//return actualProjectInstance;
		return getActualContentPanel().getProjectInstance();
	}

	@Override
	public IContentPanelComponent getActualContentPanel() {
		return contentPanel;
	}

}
