/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter;

import gwtupload.client.IUploader;
import gwtupload.client.IUploader.OnFinishUploaderHandler;

import java.util.List;

import net.customware.gwt.presenter.client.place.Place;
import net.customware.gwt.presenter.client.place.PlaceRequest;
import net.customware.gwt.presenter.client.widget.WidgetPresenter;

import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.presenter.IImportProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IImportProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetAvailableProjectTypesResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.ImportProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.GetAvailbleProjectTypes;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFoldersLoadedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IBackEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.ICancelEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IFinishEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.ILoadEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.INextEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IWizardHandler;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;

public class ImportProjectPresenter extends WidgetPresenter<IImportProjectConfigurationView> implements IImportProjectPresenter{
	
	
	public static final Place PLACE = new Place("Import.Project");
	
	public static final String PARAM_PROJECT_TYPEID = "projectTypeID";
	public static final String PARAM_PROJECT_IMPORT_FORMAT = "projectImportFormat";
	
	private IProjectType selectedProjectType;
	private IProjectInstanceFormat selectedFormat;
	private String uploadRef;
	
	private List<IProjectType> availableProjectTypes;
	private List<IProjectInstanceFormat> currentImportFormats;
	
	private IEditorEventBus eventBus;
	
	private boolean availableTypeAlreadyDisplayed = false;
	
	public ImportProjectPresenter(IImportProjectConfigurationView display,
			IEditorEventBus eventBus) {
		super(display, eventBus);
		this.eventBus = eventBus;
	}

	public List<IProjectType> getAvailableProjectTypes() {
		return availableProjectTypes;
	}
	
	@Override
	public Place getPlace() {
		return PLACE;
	}

	@Override
	protected void onBind() {
		
		
		//request available project types
		eventBus.fireEvent(new RequestEvent(new GetAvailbleProjectTypes(), new IGetAvailableProjectTypesResponseHandler() {
			
			@Override
			public void receiveResponse(List<IProjectType> result) {
				
				availableProjectTypes = result;

			}
		}));
		
		//////FOLDER PANEL HANDLER
		display.getFolderPanel().addHandler(new IFolderPanelHandler() {
			
			@Override
			public void onFoldersLoaded(IFoldersLoadedEvent event) {

				
			}
			
			@Override
			public void onFolderSelected(IFolderSelectedEvent event) {
				
				//when a project type is selected build request
				IProjectType projectType = (IProjectType) event.getFolder().getValue("projectType");
				
				String req = PLACE.requestWith(PARAM_PROJECT_TYPEID, projectType.getId()).toString(); 
				
				History.newItem(req);
				

				
			}
		});
		
		//////IMPORT FORMAT COMBOBOX HANDLER
		display.getImportFormat().addValueChangeHandler(new ValueChangeHandler<IProjectInstanceFormat>() {
			
			@Override
			public void onValueChange(ValueChangeEvent<IProjectInstanceFormat> event) {
				
				//add import format to request
				String req = PLACE.request().with(PARAM_PROJECT_TYPEID, selectedProjectType.getId()).with(PARAM_PROJECT_IMPORT_FORMAT, event.getValue().toString()).toString();
			
				History.newItem(req);
				
				
			}
		});
		
		////////UPLOAD HANDLER
		display.getUploader().addOnFinishUploadHandler(new OnFinishUploaderHandler() {
			
			@Override
			public void onFinish(IUploader uploader) {
				
				uploadRef = uploader.getInputName();

				//Send import configuration complete event
				if(selectedProjectType!=null && selectedFormat!=null){
					eventBus.fireEvent(new ImportProjectConfigurationCompleteEvent(uploadRef, selectedProjectType, selectedFormat, getDisplay()));
					selectedProjectType = null;
					selectedFormat = null;
					display.refresh();
					display.close();
				}
				//TODO:activate finish btn 
				
			}
		});
		
		
		
		//TODO: when receiving the list of project instance display them
		//so that user can choose which one(s) he wants to open
		
		
		///////WIZARD HANDLER
		display.getWizard().addHandler(new IWizardHandler() {
			
			@Override
			public void onNext(INextEvent event) {}
			
			@Override
			public void onLoad(ILoadEvent event) {}
			
			@Override
			public void onFinish(IFinishEvent event) {
				
				//display.close();
				display.getUploader().submit();
				
			}
			
			@Override
			public void onCancel(ICancelEvent event) {
				
				display.close();
				
			}
			
			@Override
			public void onBack(IBackEvent event) {}
		});
		
	}

	@Override
	protected void onPlaceRequest(PlaceRequest request) {
		
		String selectedProjectTypeID 			= request.getParameter(PARAM_PROJECT_TYPEID, null);
		String selectedProjectImportFormat		= request.getParameter(PARAM_PROJECT_IMPORT_FORMAT, null);
		
		//retrieve selected project type by id
		if (selectedProjectTypeID!=null){
			for(IProjectType pt:availableProjectTypes){
				
				if (pt.getId().equals(selectedProjectTypeID)){
					
					this.selectedProjectType = pt;
					
					//set current project import formats
					if (selectedProjectType.getImportFormats()==null)
						throw new IllegalStateException("Actual project type:"+selectedProjectType+" doesn't have any associated import format");
					
					this.currentImportFormats = selectedProjectType.getImportFormats();
					
					break;
				}
				
				
			}
		}
		
		//retrieve selected project format
		if (selectedProjectImportFormat!=null){
			
			for(IProjectInstanceFormat f:currentImportFormats){
				
				if (f.toString().equals(selectedProjectImportFormat)){
					selectedFormat = f;
				}
				
			}
			
			
		}
		
	
		refreshDisplay();
		
	}

	
	
	
	private void updateImportFormats() {
		
		//first clear combobox
		getDisplay().getImportFormat().clear();
		
		//the add all new current import formats
		for(IProjectInstanceFormat f:currentImportFormats){
			
			getDisplay().getImportFormat().addItem(f, f.toString());
			
		}
		
	}
	
	@Override
	protected void onUnbind() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void refreshDisplay() {
		
		//refresh project types
		if (availableProjectTypes!=null && availableTypeAlreadyDisplayed==false){
			display.setAvailableProjectTypes(availableProjectTypes);
			
			availableTypeAlreadyDisplayed = true;
			
		}
		
		//update import format combobox
		if (selectedProjectType!=null) updateImportFormats();
		
	
		
		//change actual combobox value
		if (selectedFormat!=null){
			display.getImportFormat().setValue(selectedFormat);
			display.getImportFormatDescription().setValue(selectedFormat.getDescription());
		}
		
		
		
	}

	@Override
	public void revealDisplay() {
		
		if (selectedFormat==null&&selectedProjectType==null){
			display.open();
		}
		
	}
	
	@Override
	public String getUploadRef() {
		return uploadRef;
	}

	@Override
	public List<IProjectInstanceFormat> getCurrentImportFormats() {
		return currentImportFormats;
	}

	@Override
	public IProjectInstanceFormat getSelectedImportFormat() {
		return selectedFormat;
	}

	@Override
	public IProjectType getSelectedProjectType() {
		return selectedProjectType;
	}
}
