/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.component.menu;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IAddMenuItemEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IClickEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IMenuComponentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IMenuItemHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IUpdateMenuItemEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuButtonItem;
import com.ebmwebsourcing.geasytools.webeditor.api.components.menu.IMenuItem;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.Component;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.AddMenuItemEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.ClickEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.UpdateMenuItemEvent;
import com.google.gwt.event.shared.GwtEvent;


public abstract class MenuComponent extends Component implements IMenuComponent{

	private HashSet<IMenuButtonItem> menuButtons;
	
	public MenuComponent() {
		this.menuButtons = new HashSet<IMenuButtonItem>();
	}
	
	
	@Override
	public void addMenuButton(IMenuButtonItem button) {
		this.menuButtons.add(button);
	}
	
	
	@Override
	public HashSet<IMenuButtonItem> getMenuButtons() {
		return menuButtons;
	}
	
	@Override
	public void addHandler(IMenuComponentHandler handler) {
		super.addHandler(handler);
		this.handlerManager.addHandler(ClickEvent.TYPE, handler);
		this.handlerManager.addHandler(AddMenuItemEvent.TYPE, handler);
		this.handlerManager.addHandler(UpdateMenuItemEvent.TYPE, handler);
	}
	
	
}
