/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.manager;

import com.ebmwebsourcing.geasytools.webeditor.api.core.IEditorFrontController;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IManager;
import com.ebmwebsourcing.geasytools.webeditor.api.service.IServiceFactory;

public abstract class AbstractManager implements IManager{
	
	private IEditorEventBus eventBus;
	private IEditorFrontController controller;
	private IServiceFactory serviceFactory;
	
	public AbstractManager(IEditorFrontController controller) {
		
		this.eventBus 		= controller.getEventBus();
		this.controller 	= controller;
		
		this.serviceFactory = controller.getServiceFactory();
		
		bindEvents();
	}
	
	@Override
	public IEditorEventBus getEventBus() {
		return eventBus;
	}
	
	@Override
	public IEditorFrontController getFrontController() {
		return controller;
	}
	
	@Override
	public IServiceFactory getServiceFactory() {
		return serviceFactory;
	}
	
}
