/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.component;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.components.IQualifiedName;
import com.ebmwebsourcing.geasytools.webeditor.api.components.events.IComponentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.IPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.ComponentAfterDispatchEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.component.events.ComponentLoadedEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.ComponentHideEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.ComponentShownEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Composite;

public abstract class Component extends Composite implements IComponent{
	
	private IPlaceHolder placeHolder;
	private IQualifiedName qname;
	protected HandlerManager handlerManager;
	
	public Component() {

		this.handlerManager = new HandlerManager(this);
	}


	@Override
	public IPlaceHolder getPlaceHolder() {
		return placeHolder;
	}

	@Override
	public IQualifiedName getQualifiedName() {
		return qname;
	}

	@Override
	public void hide() {
		this.setVisible(false);
		this.getPlaceHolder().fireEvent(new ComponentHideEvent(this));
	}

	@Override
	public void addHandler(IComponentHandler handler) {
		handlerManager.addHandler(ComponentLoadedEvent.TYPE, handler);
		handlerManager.addHandler(ComponentAfterDispatchEvent.TYPE, handler);
	}

	@Override
	public void setPlaceHolder(IPlaceHolder placeHolder) {
		this.placeHolder = placeHolder;
	}

	@Override
	public void show() {
		this.setVisible(true);
		this.getPlaceHolder().fireEvent(new ComponentShownEvent(this));
	}

	
	@Override
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}
	
}
