/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import net.customware.gwt.presenter.client.place.Place;
import net.customware.gwt.presenter.client.place.PlaceRequest;
import net.customware.gwt.presenter.client.widget.WidgetPresenter;

import com.ebmwebsourcing.geasytools.webeditor.api.core.DefaultErrorLevel;
import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.presenter.IOpenProjectPresenter;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IOpenProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetAvailableProjectTypesResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetProjectFilesByTypeResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetProjectInstanceByURLResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.URLFixHelper;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.EditorErrorEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events.OpenProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.GetAvailbleProjectTypes;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.GetProjectFilesByTypeRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.request.GetProjectInstanceByURLRequest;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.request.RequestEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFile;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFileSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFilesLoadedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFoldersLoadedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerCancelEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.events.IFileExplorerValidateEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IBackEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.ICancelEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IFinishEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.ILoadEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.INextEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IWizardHandler;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;

public class OpenProjectPresenter extends WidgetPresenter<IOpenProjectConfigurationView> implements IOpenProjectPresenter{
	
	public static final Place PLACE = new Place("Open.Project");
	
	public static final String PARAM_PROJECT_TYPEID = "type";
	public static final String PARAM_PROJECT_ID = "id";
	public static final String PARAM_PROJECT_URL = "url";
	public static final String PARAM_PROJECT_FORMAT = "format";
	
	private HashSet<IFile> selectedFiles;

	
	private String selectedProjectsIDs;
	private String selectedProjectTypeID;
	private String selectedProjectURL;
	private String selectedProjectFormat;
	
	private List<IProjectType> availableProjectTypes;
	private List<IProjectFile> currentProjectFiles;
	
	private List<IProjectFile> selectedProjectFiles;
	private IProjectType selectedProjectType;
	
	private IEditorEventBus eventBus;

	private boolean projectTypesAlreadyLoaded = false;
	
	public List<IProjectType> getAvailableProjectTypes() {
		return availableProjectTypes;
	}
	
	public List<IProjectFile> getCurrentProjectFiles() {
		return currentProjectFiles;
	}
	
	public OpenProjectPresenter(IOpenProjectConfigurationView display,
			IEditorEventBus eventBus) {
		super(display, eventBus);
		
		this.eventBus = eventBus;
		
	}

	@Override
	protected void onBind() {
		
		//request available project types
		eventBus.fireEvent(new RequestEvent(new GetAvailbleProjectTypes(), new IGetAvailableProjectTypesResponseHandler() {
			
			@Override
			public void receiveResponse(List<IProjectType> result) {
				
				availableProjectTypes = result;
				refreshDisplay();
			}
		}));
		
		
		/////FILE EXPLORER HANDLER
		display.getFileExplorerPanel().addHandler(new IFileExplorerPanelHandler() {
			
			@Override
			public void onFoldersLoaded(IFoldersLoadedEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onFolderSelected(IFolderSelectedEvent event) {
				
				//when a project type is selected build request
				IProjectType projectType = (IProjectType) event.getFolder().getValue("projectType");
				
				String req = OpenProjectPresenter.PLACE.requestWith(OpenProjectPresenter.PARAM_PROJECT_TYPEID, projectType.getId()).toString(); 
				
				History.newItem(req);
					
			}
			
			@Override
			public void onFilesSelected(IFileSelectedEvent event) {
			
				if (selectedProjectTypeID!=null){
				//when a file is selected build request
				selectedFiles = event.getFiles();
				
				String ids = null;
				
				
				int i 	= 0;
				int max = selectedFiles.size();
				
				Iterator<IFile> it = selectedFiles.iterator(); 
				
				while(it.hasNext()){
					
					IFile file = it.next();
					
					IProjectFile pf = (IProjectFile) file.getValue("projectFile");
					
					if (i<max && i!=0){
						
						ids = ids + "," + pf.getId();
						
					}else if (i==0){
						
						ids = pf.getId();
						
					}else if (i==max){
						
						ids = ids + pf.getId();
						
					}
					
					i++;
				}
				
				String req = OpenProjectPresenter.PLACE.requestWith(OpenProjectPresenter.PARAM_PROJECT_TYPEID, selectedProjectTypeID).with(OpenProjectPresenter.PARAM_PROJECT_ID, ids).toString();
				
				History.newItem(req);

				}else{
					
					eventBus.fireEvent(new EditorErrorEvent("Select project type", "Please, select a project type first", DefaultErrorLevel.ERROR));
					
				}
			}
			
			@Override
			public void onFilesLoaded(IFilesLoadedEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onValidate(IFileExplorerValidateEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onCancel(IFileExplorerCancelEvent event) {
				

				
			}
		});
		
		////WIZARD HANDLER
		display.getWizard().addHandler(new  IWizardHandler() {
			
			@Override
			public void onNext(INextEvent event) {}
			
			@Override
			public void onLoad(ILoadEvent event) {
				
			
			
			}
			
			@Override
			public void onFinish(IFinishEvent event) {

				//when finish set finish param in request
				eventBus.fireEvent(new OpenProjectConfigurationCompleteEvent(selectedProjectFiles,selectedProjectType));
				
				display.setProjectFiles(new ArrayList<IProjectFile>());
				
				display.close();
				

				
			}
			
			@Override
			public void onCancel(ICancelEvent event) {
				
				display.close();
				
			}
			
			@Override
			public void onBack(IBackEvent event) {}
		});
		
		
		
		
	
		
	}
	



	@Override
	protected void onUnbind() {
		
		
	}

	@Override
	public Place getPlace() {
		return PLACE;
	}

	@Override
	protected void onPlaceRequest(PlaceRequest request) {

		this.selectedProjectTypeID 		= request.getParameter(PARAM_PROJECT_TYPEID, null);
		this.selectedProjectsIDs		= request.getParameter(PARAM_PROJECT_ID, null);
		this.selectedProjectURL			= URLFixHelper.fixURL(request.getParameter(PARAM_PROJECT_URL, null));
		this.selectedProjectFormat		= request.getParameter(PARAM_PROJECT_FORMAT, null);
		
		if (selectedProjectTypeID!=null && selectedProjectsIDs==null && selectedProjectURL==null){
			
			doGetProjectsFilesByTypeRequest();
			
			
		}
		
		
		//open project with the given url
		if (selectedProjectTypeID!=null && selectedProjectURL!=null && selectedProjectsIDs==null &&selectedProjectFormat!=null){
			doLoadProjectByURL();
		}
		
		//if used selected some files open them
		if (selectedProjectsIDs!=null){
			
			List<IProjectFile> projectFiles = new ArrayList<IProjectFile>();
			
			String[] ids = selectedProjectsIDs.split(",");
			
			
			for(String id : ids){
				
				for(IProjectFile pf:currentProjectFiles){
					
					if (pf.getId().equals(id)){
						
						projectFiles.add(pf);
						
					}
					
				}
				
			}
			
			this.selectedProjectFiles = projectFiles;

			
		}
		
		
	}
	
	
	private void doLoadProjectByURL(){
		
		System.out.println("Project URL==>"+this.selectedProjectURL);
		
		IProjectType type = null;
		IProjectInstanceFormat format = null;
		
		for(IProjectType pt:availableProjectTypes){
			
			if (pt.getId().equals(selectedProjectTypeID)){
				
				type = pt;
				break;
			}
			
		}
		
		if (type!=null){
			for(IProjectInstanceFormat f:type.getImportFormats()){
				
				if (f.getName().equals(this.selectedProjectFormat)){
					format = f;
					break;
				}
				
			}
		}
		
		if (type!=null && format!=null){
			eventBus.fireEvent(new RequestEvent(new GetProjectInstanceByURLRequest(this.selectedProjectURL, format, type), new IGetProjectInstanceByURLResponseHandler() {
				
				@Override
				public void receiveResponse(IProjectInstance result) {
					
					eventBus.fireEvent(new OpenProjectConfigurationCompleteEvent(result));
					
					History.newItem("");
				}
			}));
		}else{
			
			eventBus.fireEvent(new EditorErrorEvent("Invalid parameters", "Some of the parameter values are invalid", DefaultErrorLevel.ERROR));
			
		}
		
		
		
	}
	
	private void doGetProjectsFilesByTypeRequest(){
	
		
		for(IProjectType pt:availableProjectTypes){
			if (pt.getId().equals(selectedProjectTypeID)){
				
				eventBus.fireEvent(new RequestEvent(new GetProjectFilesByTypeRequest(pt), new IGetProjectFilesByTypeResponseHandler() {
					
					@Override
					public void receiveResponse(List<IProjectFile> result) {
						
						currentProjectFiles = result;
						refreshDisplay();
					}
				}));
				
				selectedProjectType = pt;
				
				break;
			}
		}
		
		
		
	}
	
	
	
	@Override
	public void refreshDisplay() {
		
		if (availableProjectTypes!=null && this.projectTypesAlreadyLoaded==false){
			display.setAvailableProjectTypes(availableProjectTypes);
			projectTypesAlreadyLoaded = true;
		}
		
		if (currentProjectFiles!=null) display.setProjectFiles(currentProjectFiles);
		
	}

	@Override
	public void revealDisplay() {

		if (selectedProjectsIDs==null && selectedProjectTypeID==null && selectedProjectURL==null){
			display.open();
		}
	}
	
	
	
	
	
}
