/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.presenter;

import com.ebmwebsourcing.geasytools.webeditor.api.core.events.IEditorEventBus;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IGetActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IGetAvailableProjectTypesRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IGetProjectFilesByTypeRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.request.IValidateActualProjectInstanceRequest;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetAvailableProjectTypesResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IGetProjectFilesByTypeResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.project.response.IValidateActualProjectInstanceResponseHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequestEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.request.IRequestHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.core.events.EditorEventBus;
import com.ebmwebsourcing.geasytools.widgets.core.api.input.IComboBox;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFile;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFilePanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolder;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolderPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.explorer.IFileExplorerPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.IWizard;
import com.ebmwebsourcing.geasytools.widgets.ext.api.wizard.event.IWizardHandler;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectFile;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectFormat;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectType;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.History;
import java.util.ArrayList;
import net.customware.gwt.presenter.client.place.PlaceParsingException;
import net.customware.gwt.presenter.client.place.PlaceRequest;
import net.customware.gwt.presenter.client.place.PlaceRequestEvent;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Before;

public abstract class AbstractCommonPresentersTest {
    protected IWizard wizardMock;
    protected IFileExplorerPanel fileExplorerPanelMock;
    protected IFilePanel filePanelMock;
    protected IFolderPanel folderPanelMock;
    protected IFolder folderMock;
    protected IFile fileMock;
    protected IComboBox<IProjectInstanceFormat> comboboxMock;
    protected IProjectType projectTypeMock;
    protected IProjectFile projectFileMock;
    protected IProjectInstance projectInstanceMock;
    protected IEditorEventBus eventBus;
    protected ArrayList<IProjectType> projectTypes;
    protected ArrayList<IProjectFile> projectFiles;
    protected ValueChangeHandler<IProjectInstanceFormat> comboboxValueChangeHandler;
    protected IFolderPanelHandler folderPanelHandler;
    protected ArrayList<IProjectInstanceFormat> importFormats;
    protected ArrayList<IProjectInstanceFormat> exportFormats;
    protected IWizardHandler wizardHandler;

    @Before
    public void setUpMocks() {
        this.setUpNonMocks();
        this.wizardMock = (IWizard)EasyMock.createMock(IWizard.class);
        this.fileExplorerPanelMock = (IFileExplorerPanel)EasyMock.createMock(IFileExplorerPanel.class);
        this.filePanelMock = (IFilePanel)EasyMock.createMock(IFilePanel.class);
        this.folderPanelMock = (IFolderPanel)EasyMock.createMock(IFolderPanel.class);
        this.fileMock = (IFile)EasyMock.createMock(IFile.class);
        this.folderMock = (IFolder)EasyMock.createMock(IFolder.class);
        this.comboboxMock = (IComboBox)EasyMock.createMock(IComboBox.class);
        this.projectTypeMock = (IProjectType)EasyMock.createMock(IProjectType.class);
        this.projectInstanceMock = (IProjectInstance)EasyMock.createMock(IProjectInstance.class);
        EasyMock.expect((Object)this.folderMock.getValue((String)EasyMock.isA(String.class))).andReturn((Object)this.projectTypeMock);
        EasyMock.replay((Object[])new Object[]{this.folderMock});
        this.comboboxMock.addValueChangeHandler((ValueChangeHandler)EasyMock.isA(ValueChangeHandler.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                Object[] params = EasyMock.getCurrentArguments();
                AbstractCommonPresentersTest.this.comboboxValueChangeHandler = (ValueChangeHandler)params[0];
                return null;
            }
        });
        this.comboboxMock.clear();
        EasyMock.expectLastCall().times(2);
        this.comboboxMock.addItem(EasyMock.isA(IProjectInstanceFormat.class), (String)EasyMock.isA(String.class));
        EasyMock.expectLastCall().times(2);
        this.comboboxMock.setValue(EasyMock.isA(IProjectInstanceFormat.class));
        EasyMock.replay((Object[])new Object[]{this.comboboxMock});
        this.folderPanelMock.addHandler((IFolderPanelHandler)EasyMock.isA(IFolderPanelHandler.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                Object[] params = EasyMock.getCurrentArguments();
                AbstractCommonPresentersTest.this.folderPanelHandler = (IFolderPanelHandler)params[0];
                return null;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.folderPanelMock});
        this.wizardMock.addHandler((IWizardHandler)EasyMock.isA(IWizardHandler.class));
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                Object[] args = EasyMock.getCurrentArguments();
                AbstractCommonPresentersTest.this.wizardHandler = (IWizardHandler)args[0];
                return null;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.wizardMock});
        EasyMock.expect((Object)this.projectTypeMock.getId()).andReturn((Object)this.projectTypes.get(0).getId()).anyTimes();
        EasyMock.expect((Object)this.projectTypeMock.getName()).andReturn((Object)this.projectTypes.get(0).getName()).anyTimes();
        EasyMock.expect((Object)this.projectTypeMock.getExportFormats()).andReturn(this.exportFormats).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.projectTypeMock});
    }

    public void setUpNonMocks() {
        this.eventBus = new EditorEventBus();
        ProjectFormat format1 = new ProjectFormat("Format 1", "Format 1 description");
        this.importFormats = new ArrayList();
        this.exportFormats = new ArrayList();
        this.importFormats.add((IProjectInstanceFormat)format1);
        this.exportFormats.add((IProjectInstanceFormat)format1);
        this.projectTypes = new ArrayList();
        ProjectType pt1 = new ProjectType("pt1", "pt1 name", "pt1 description", this.importFormats, this.exportFormats);
        this.projectTypes.add((IProjectType)pt1);
        this.projectFiles = new ArrayList();
        ProjectFile pf1 = new ProjectFile();
        pf1.setName("File 1");
        pf1.setId("1");
        pf1.setAbsolutePath("/absolutePath");
        ProjectFile pf2 = new ProjectFile();
        pf2.setName("File 2");
        pf2.setId("2");
        pf2.setAbsolutePath("/absolutePath");
        this.projectFiles.add((IProjectFile)pf1);
        this.projectFiles.add((IProjectFile)pf2);
        this.eventBus.addRequestHandler(new IRequestHandler(){

            public void onRequest(IRequestEvent event) {
                if (event.getRequest() instanceof IGetAvailableProjectTypesRequest) {
                    IGetAvailableProjectTypesResponseHandler res = (IGetAvailableProjectTypesResponseHandler)event.getResponseHandler();
                    res.receiveResponse(AbstractCommonPresentersTest.this.projectTypes);
                } else if (event.getRequest() instanceof IGetProjectFilesByTypeRequest) {
                    IGetProjectFilesByTypeResponseHandler res = (IGetProjectFilesByTypeResponseHandler)event.getResponseHandler();
                    res.receiveResponse(AbstractCommonPresentersTest.this.projectFiles);
                } else if (event.getRequest() instanceof IGetActualProjectInstanceRequest) {
                    IGetActualProjectInstanceResponseHandler res = (IGetActualProjectInstanceResponseHandler)event.getResponseHandler();
                    res.receiveResponse((Object)AbstractCommonPresentersTest.this.projectInstanceMock);
                } else if (event.getRequest() instanceof IValidateActualProjectInstanceRequest) {
                    IValidateActualProjectInstanceResponseHandler res = (IValidateActualProjectInstanceResponseHandler)event.getResponseHandler();
                    res.receiveResponse(null);
                }
            }
        });
        History.newItemInvokedHandler = new History.NewItemInvokedHandler(){

            public void handle(String item) {
                System.out.println("new item added to history=>" + item);
                try {
                    AbstractCommonPresentersTest.this.eventBus.fireEvent((GwtEvent)new PlaceRequestEvent(PlaceRequest.fromString((String)item)));
                }
                catch (PlaceParsingException e) {
                    e.printStackTrace();
                }
            }
        };
    }
}

