/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core;

import net.customware.gwt.presenter.client.place.PlaceParsingException;
import net.customware.gwt.presenter.client.place.PlaceRequest;

import com.google.gwt.user.client.Window;

public class URLFixHelper {

	
	public static void fix(){
		//System.out.println("=======>"+Window.Location.getHash().replace("=", ":"));
//		System.out.println("href===>"+Window.Location.getHref());
//		System.out.println("host===>"+Window.Location.getHost());
//		System.out.println("path===>"+Window.Location.getPath());
//		System.out.println("hostName===>"+Window.Location.getHostName());
//		System.out.println("queryString===>"+Window.Location.getQueryString());
			
		if (Window.Location.getHash().contains("url=")){
		
			try {		
			
				String t = Window.Location.getHash().replace("=", ":");
			
			t = t.replace("type:", "type=");
			t = t.replace("format:", "format=");
			t = t.replace("url:", "url=");
			
//			System.out.println("==>"+t);
			
			PlaceRequest p = PlaceRequest.fromString(t);
			
			String currentURL = p.getParameter("url", null).replace(":", "=").replace("http=", "http:");
			
//			System.out.println("URL==>"+currentURL);
			
			String finalHash = Window.Location.getHash().replace(currentURL, currentURL.replace("=", ":"));
		
			
			String finalURL = Window.Location.getProtocol()+ Window.Location.getPath()+ Window.Location.getQueryString()+ finalHash;
			
			System.out.println("URL FIX:"+finalURL);
			
			Window.Location.replace(finalURL);
			
			} catch (PlaceParsingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}
	
	}
	
	public static String fixURL(String url){
		if (url==null) return null;
		return url.replace(":", "=").replace("http=", "http:");
	}
	
}
