/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.mainmenu;

import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.mainmenu.IDefaultSystemContentHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IMainMenuManager;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.IContentUpdateEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.content.events.ISelectContentElementsEvent;

public class DefaultSystemContentHandler implements IDefaultSystemContentHandler{
	
	private IMainMenuManager mainMenuManager;
	
	public DefaultSystemContentHandler(IMainMenuManager mainMenuManager) {
		this.mainMenuManager = mainMenuManager;
	}
	
	@Override
	public IMainMenuManager getMainMenuManager() {
		return mainMenuManager;
	}

	@Override
	public void onSelectContentElements(ISelectContentElementsEvent event) {
		
		
		if (event.getContentElements()==null){
			
			enableEditItems(false);
			
		}else{
			
			enableEditItems(true);
			
		}
		
	}

	
	private void enableEditItems(boolean b){
		
		
		mainMenuManager.getFrontController().getView().getMainMenuComponent().getCopyItem().setEnable(b);	
		//mainMenuManager.getFrontController().getView().getMainMenuComponent().getPasteItem().setEnable(b);
		//mainMenuManager.getFrontController().getView().getMainMenuComponent().getSelectAllItem().setEnable(b);
		mainMenuManager.getFrontController().getView().getMainMenuComponent().getDeleteItem().setEnable(b);
	}

	@Override
	public void onContentUpdate(IContentUpdateEvent event) {
		// TODO Auto-generated method stub
		
	}
	

}
