/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.core.handler.manager.toolbar;

import com.ebmwebsourcing.geasytools.webeditor.api.components.toolbar.IToolbarComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.core.handler.manager.toolbar.IDefaultPluginHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.core.manager.IToolbarManager;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.events.IPluginRegisteredEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.plugin.events.IPluginRegistrationCompleteEvent;

public class DefaultPluginHandler implements IDefaultPluginHandler{
	
	private IToolbarManager toolbarManager;
	
	public DefaultPluginHandler(IToolbarManager toolbarManager) {
		this.toolbarManager = toolbarManager;
	}
	
	@Override
	public IToolbarManager getToolbarManager() {
		return toolbarManager;
	}

	@Override
	public void onPluginRegistered(IPluginRegisteredEvent event) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onPluginRegistrationComplete(
			IPluginRegistrationCompleteEvent event) {
		
		IToolbarComponent tbc = toolbarManager.getFrontController().getView().getToolbarComponent();
		
		tbc.getDeleteBtn().setEnabled(false);
		
	}

}
