/**
 * webeditor-impl - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.events;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IOpenProjectConfigurationCompleteEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.events.IProjectConfigurationHandler;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectFile;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.google.gwt.event.shared.GwtEvent;

public class OpenProjectConfigurationCompleteEvent extends GwtEvent<IProjectConfigurationHandler> implements IOpenProjectConfigurationCompleteEvent{
	
	public static Type<IProjectConfigurationHandler> TYPE = new Type<IProjectConfigurationHandler>();
	
	private List<IProjectFile> projectFiles;
	private IProjectConfigurationView view;
	private IProjectType projectType;
	private IProjectInstance projectInstance;
	
	public OpenProjectConfigurationCompleteEvent(List<IProjectFile> projectFiles,IProjectType projectType) {
		this.projectFiles 	= projectFiles;
		this.projectType 	= projectType; 
	}
	
	public OpenProjectConfigurationCompleteEvent(IProjectInstance projectInstance) {
		this.projectInstance = projectInstance;
	}
	
	public OpenProjectConfigurationCompleteEvent(List<IProjectFile> projectFiles,IProjectType projectType,IProjectConfigurationView view) {
		this(projectFiles,projectType);
		this.view = view;
	}
	
	@Override
	protected void dispatch(IProjectConfigurationHandler handler) {
		handler.onConfigurationComplete(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IProjectConfigurationHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public List<IProjectFile> getProjectFiles() {	
		return projectFiles;
	}

	@Override
	public IProjectConfigurationView getProjectConfigurationView() {
		return view;
	}

	@Override
	public IProjectType getProjectType() {
		return projectType;
	}

	@Override
	public IProjectInstance getProjectInstance() {
		return projectInstance;
	}

}
