/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webeditor.server.impl.service.project;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstance;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceFormat;
import com.ebmwebsourcing.webeditor.api.domain.project.IProjectInstanceMetaData;
import com.ebmwebsourcing.webeditor.client.impl.service.project.PropertyFileProjectInstance;
import com.ebmwebsourcing.webeditor.impl.domain.exception.ServiceException;
import com.ebmwebsourcing.webeditor.shared.server.api.service.project.IProjectInstanceWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertyFileProjectInstanceWriter
implements IProjectInstanceWriter {
    public File writeProjectFile(IProjectInstance projectInstance, File projectOutputDirectory) {
        File result = new File(projectOutputDirectory.getAbsoluteFile() + File.separator + projectInstance.getName() + ".properties");
        PropertyFileProjectInstance pfpi = (PropertyFileProjectInstance)projectInstance;
        Properties properties = new Properties();
        properties.setProperty("content", pfpi.getContent());
        try {
            properties.store(new FileOutputStream(result), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public File writeProjectFile(File projectInstanceFile, IProjectInstanceFormat formatToWriteIn, File temporaryOutputDirectory) {
        Properties p1 = new Properties();
        try {
            p1.load(new FileInputStream(projectInstanceFile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        File result = new File(temporaryOutputDirectory.getAbsoluteFile() + File.separator + projectInstanceFile.getName() + ".txt");
        Properties properties = new Properties();
        properties.setProperty("content", p1.getProperty("content"));
        try {
            properties.store(new FileOutputStream(result), null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public File writeProjectFile(File projectFile, IProjectInstanceMetaData exportData, IProjectInstanceFormat format, File directory) throws ServiceException {
        return this.writeProjectFile(projectFile, format, directory);
    }
}

