/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webeditor.server.impl.service.upload;

import gwtupload.server.UploadServlet;
import java.io.File;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.mortbay.jetty.testing.ServletTester;

public class UploadClient {
    private File fileToUpload;
    private ServletTester servletTester = new ServletTester();
    private String baseUrl;
    private DefaultHttpClient httpclient;
    public static String UPLOAD_FIELD_NAME = "bin";

    public UploadClient() {
        this.servletTester.setContextPath("/");
        this.servletTester.addServlet(UploadServlet.class, "/upload");
        this.httpclient = new DefaultHttpClient();
    }

    public HttpResponse uploadFile(File file) throws ClientProtocolException, IOException {
        this.fileToUpload = file;
        HttpPost httppost = new HttpPost(this.baseUrl + "/upload");
        FileBody bin = new FileBody(this.fileToUpload);
        MultipartEntity reqEntity = new MultipartEntity();
        reqEntity.addPart(UPLOAD_FIELD_NAME, (ContentBody)bin);
        httppost.setEntity((HttpEntity)reqEntity);
        HttpResponse response = this.httpclient.execute((HttpUriRequest)httppost);
        HttpEntity resEntity = response.getEntity();
        EntityUtils.consume((HttpEntity)resEntity);
        return response;
    }

    public Servlet addServlet(Class<?> servlet, String pathSpec) throws ServletException {
        return this.servletTester.addServlet(servlet, pathSpec).getServlet();
    }

    public File getUploaddedFile() {
        return this.fileToUpload;
    }

    public DefaultHttpClient getHttpclient() {
        return this.httpclient;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void startServletTester() throws Exception {
        this.baseUrl = this.servletTester.createSocketConnector(true);
        this.servletTester.start();
    }

    public void stopServletTester() throws Exception {
        this.servletTester.stop();
    }

    public void shutDownHttpClient() {
        this.httpclient.getConnectionManager().shutdown();
    }
}

