/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.webeditor.server.impl.service.upload;

import com.ebmwebsourcing.webeditor.api.domain.project.IProjectType;
import com.ebmwebsourcing.webeditor.api.domain.user.IUser;
import com.ebmwebsourcing.webeditor.impl.domain.project.ProjectType;
import com.ebmwebsourcing.webeditor.impl.domain.user.User;
import com.ebmwebsourcing.webeditor.server.impl.service.common.AbstractCommonServiceTest;
import com.ebmwebsourcing.webeditor.server.impl.service.upload.UploadClient;
import com.ebmwebsourcing.webeditor.server.impl.service.upload.UploadServiceServlet;
import com.ebmwebsourcing.webeditor.server.impl.service.webeditor.WebEditorService;
import java.io.File;
import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.junit.Test;

public class UploadServiceImplTest
extends AbstractCommonServiceTest {
    private static UploadClient uploadClient;

    @Test
    public void testGetUploadedFileFromSession() throws Exception {
        uploadClient = new UploadClient();
        uploadClient.startServletTester();
        uploadClient.addServlet(UploadServiceServlet.class, "/mock");
        uploadClient.uploadFile(new File(this.getActualPath() + "file1.properties"));
        HttpGet httpget = new HttpGet(uploadClient.getBaseUrl() + "/mock");
        HttpResponse response = uploadClient.getHttpclient().execute((HttpUriRequest)httpget);
        StatusLine statusLine = response.getStatusLine();
        Assert.assertEquals((int)200, (int)statusLine.getStatusCode());
        EntityUtils.consume((HttpEntity)response.getEntity());
        File tmpUploadFileDirectory = WebEditorService.getInstance().getTemporaryUploadFolderDirectory((IUser)UploadServiceImplTest.getLogeddUser(), (IProjectType)UploadServiceImplTest.getProjectType());
        File tmpUploadedFile = new File(tmpUploadFileDirectory.getAbsolutePath() + File.separator + uploadClient.getUploaddedFile().getName());
        Assert.assertTrue((boolean)tmpUploadedFile.exists());
        Assert.assertEquals((long)uploadClient.getUploaddedFile().length(), (long)tmpUploadedFile.length());
        Assert.assertEquals((String)uploadClient.getUploaddedFile().getName(), (String)tmpUploadedFile.getName());
        uploadClient.stopServletTester();
        uploadClient.shutDownHttpClient();
    }

    public static User getLogeddUser() {
        User user = new User();
        user.setId("userID");
        return user;
    }

    public static ProjectType getProjectType() {
        ProjectType projectType = new ProjectType();
        projectType.setId("projectTypeID");
        return projectType;
    }
}

