/**
 * webeditor-ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.layout;




import java.util.HashMap;

import com.ebmwebsourcing.geasytools.webeditor.api.components.IContentPanelComponent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.DefaultPlaceHolderPositions;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.IContentPanelPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.IMainMenuPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.IToolBarPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IAddComponentEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IComponentHideEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IComponentShowEvent;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IMultipleComponentPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.api.layout.events.IPlaceHolderHandler;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.AbstractLayout;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.ContentPanelPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.MainMenuPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.MultipleComponentsPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.ToolbarPlaceHolder;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.layout.events.PanelChangeEvent;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Margins;
import com.gwtext.client.core.RegionPosition;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.TabPanel;
import com.gwtext.client.widgets.event.TabPanelListenerAdapter;
import com.gwtext.client.widgets.layout.BorderLayout;
import com.gwtext.client.widgets.layout.BorderLayoutData;

public class DefaultLayout extends AbstractLayout{
	
	private Panel borderPanel;
	private IMainMenuPlaceHolder mainMenuPlaceHolder;
	private ContentPanelPlaceHolder panelPlaceHolder;
	private IToolBarPlaceHolder toolbarPlaceHolder;
	
	private HashMap<String, IContentPanelComponent> panelComponentMap;
	
	public DefaultLayout() {
		this.panelComponentMap = new HashMap<String, IContentPanelComponent>();
	}
	
	
	@Override
	public Widget getMainWidget() {
		
		if (borderPanel==null){
			
		
	         borderPanel = new Panel();  
	         borderPanel.setLayout(new BorderLayout());  
	   
	         ////////////NORTH PANEL
	      
	         final Panel northPanelContainer = new Panel();  
	         northPanelContainer.setHeight(113);
	           
	 		 HTML header = new HTML("<div class='inner-default-layout-header'></div>");
			 header.setStyleName("default-layout-header");
			 northPanelContainer.add(header);
	           
	         borderPanel.add(northPanelContainer, new BorderLayoutData(RegionPosition.NORTH));  

	         this.mainMenuPlaceHolder = new MainMenuPlaceHolder();
	         
	         mainMenuPlaceHolder.addHandler(new IPlaceHolderHandler() {
				
				public void onAddComponent(IAddComponentEvent event) {
					
					northPanelContainer.add((Widget) event.getComponent());
					northPanelContainer.doLayout();
				}
			});
	        
	         this.toolbarPlaceHolder = new ToolbarPlaceHolder();
	         
	         toolbarPlaceHolder.addHandler(new IPlaceHolderHandler() {
				
				@Override
				public void onAddComponent(IAddComponentEvent event) {
					
					northPanelContainer.add((Widget) event.getComponent());
					northPanelContainer.doLayout();					
					
				}
			});
	         
	         this.addPlaceHolder(DefaultPlaceHolderPositions.NORTH, mainMenuPlaceHolder);

	         this.addPlaceHolder(DefaultPlaceHolderPositions.NORTH, toolbarPlaceHolder);
	         //////////SOUTH PANEL
	         
	         
	         
	         //add south panel  
	         final TabPanel southPanel = new TabPanel();
	         southPanel.setHeight(200);  
	         southPanel.setCollapsible(true);  
	         southPanel.setTitle("South");  
	         southPanel.setAutoScroll(true);
	         
	         MultipleComponentsPlaceHolder southPlaceHolder = new MultipleComponentsPlaceHolder(-1);
	         southPlaceHolder.addHandler(new IMultipleComponentPlaceHolderHandler() {
				
				public void onAddComponent(IAddComponentEvent event) {

					southPanel.add((Widget) event.getComponent());
					southPanel.doLayout();
					southPanel.activate(event.getComponent().getId());

				}

				@Override
				public void onComponentHide(IComponentHideEvent event) {
					
					southPanel.hideTabStripItem(event.getComponent().getId());
					
				}

				@Override
				public void onComponentShown(IComponentShowEvent event) {
					
					southPanel.unhideTabStripItem(event.getComponent().getId());
					
				}
			});
	         
	         this.addPlaceHolder(DefaultPlaceHolderPositions.SOUTH,southPlaceHolder);
	         
	         BorderLayoutData southData = new BorderLayoutData(RegionPosition.SOUTH);  
	         southData.setMinSize(100);  
	         southData.setMaxSize(200);  
	         southData.setMargins(new Margins(0, 0, 0, 0));  
	         southData.setSplit(true);  
	         borderPanel.add(southPanel, southData);  
	   

	         /////WEST PANEL
	   
	         final TabPanel westPanel = new TabPanel(); 
	         westPanel.setTitle("West");  
	         westPanel.setCollapsible(true);  
	         westPanel.setWidth(300);  
	         westPanel.setEnableTabScroll(true);

	         
	         MultipleComponentsPlaceHolder westPlaceHolder = new MultipleComponentsPlaceHolder(-1);
	         westPlaceHolder.addHandler(new IMultipleComponentPlaceHolderHandler() {
				
				@Override
				public void onAddComponent(IAddComponentEvent event) {
					
					westPanel.add((Widget) event.getComponent());
					westPanel.doLayout();
					westPanel.activate(event.getComponent().getId());
					
				}
				
				@Override
				public void onComponentShown(IComponentShowEvent event) {
					
					westPanel.unhideTabStripItem(event.getComponent().getId());

				}
				
				@Override
				public void onComponentHide(IComponentHideEvent event) {
					
					westPanel.hideTabStripItem(event.getComponent().getId());

				}
			});
	         
	         this.addPlaceHolder(DefaultPlaceHolderPositions.WEST,westPlaceHolder);
	         //westPlaceHolder.addComponent(new com.ebmwebsourcing.geasybpmneditor.client.layout.Component());
	         
	         BorderLayoutData westData = new BorderLayoutData(RegionPosition.WEST);  
	         westData.setSplit(true);  
	         westData.setMinSize(175);  
	         westData.setMaxSize(400);  
	         westData.setMargins(new Margins(0, 5, 0, 0));  
	   
	         borderPanel.add(westPanel, westData);  

	         
	         ///////CENTER PANEL

	         final TabPanel centerPanel = new TabPanel();  
	         centerPanel.setEnableTabScroll(true);
	         
	         this.panelPlaceHolder = new ContentPanelPlaceHolder(-1);

	         
	         centerPanel.addListener(new TabPanelListenerAdapter(){
	        	 
	        	 @Override
	        	public void onTabChange(TabPanel source, Panel tab) {

	        		 IContentPanelComponent selectedComponent = panelComponentMap.get(tab.getId());
	        		
	        		panelPlaceHolder.fireEvent(new PanelChangeEvent(selectedComponent));
	        		
	        	}
	        	 
	         });
	         
	         
	         this.addPlaceHolder(DefaultPlaceHolderPositions.CENTER, panelPlaceHolder);
	         
	         
	         panelPlaceHolder.addHandler(new IPlaceHolderHandler() {
				
				@Override
				public void onAddComponent(IAddComponentEvent event) {
					
					panelComponentMap.put(event.getComponent().getId(), (IContentPanelComponent) event.getComponent());
					centerPanel.add((Widget) event.getComponent());
					centerPanel.doLayout();
					centerPanel.activate(event.getComponent().getId());
				}
			});
	         
	         
	         borderPanel.add(centerPanel, new BorderLayoutData(RegionPosition.CENTER));  
	   
		}
	         
		
		return borderPanel;
	}

	public IMainMenuPlaceHolder getMainMenuPlaceHolder() {
		return mainMenuPlaceHolder;
	}

	public IContentPanelPlaceHolder getMainContentPanelPlaceHolder() {
		return panelPlaceHolder;
	}

	@Override
	public IToolBarPlaceHolder getToolBarPlaceHolder() {
		return toolbarPlaceHolder;
	}
	
	

	
}
