/**
 * webeditor-ui - Petalslink is an open source editor providing tools for Service Oriented Architecture. - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.webeditor.ui.project.configuration.view;

import com.ebmwebsourcing.geasytools.gwtextwidgets.button.ToolbarButton;
import com.ebmwebsourcing.geasytools.gwtextwidgets.tabpanel.ComplexTabPanel;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditConfigurationPanel;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditProjectConfigurationPanel;
import com.ebmwebsourcing.geasytools.webeditor.api.project.configuration.view.IEditProjectConfigurationView;
import com.ebmwebsourcing.geasytools.webeditor.impl.client.project.configuration.view.ProjectConfigurationView;
import com.ebmwebsourcing.geasytools.widgets.core.api.button.IButton;
import com.ebmwebsourcing.geasytools.widgets.ext.api.tabpanel.IComplexTabPanel;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.WindowListenerAdapter;

public class EditProjectConfigurationView extends ProjectConfigurationView implements IEditProjectConfigurationView{
	
	private Window window;
	private ComplexTabPanel tabPanel;
	private IEditProjectConfigurationPanel projectConfigurationPanel;
	private ToolbarButton cancelBtn;
	private ToolbarButton okBtn;
	
	public EditProjectConfigurationView() {
		
		this.window = new Window("Edit Project");
		

		
		this.projectConfigurationPanel = new EditProjectConfigurationPanel();
		
		addComplexTabPanel();

		this.window.setCloseAction(Window.HIDE);
		this.window.setResizable(false);
		this.window.addListener(new WindowListenerAdapter(){
			
			@Override
			public void onHide(Component component) {
				History.newItem("");
			}
			
		
		});
		
		Toolbar toolBar = new Toolbar();

		toolBar.addFill();
		
		this.cancelBtn = new ToolbarButton("Cancel");

		this.okBtn = new ToolbarButton("Ok");
		
		toolBar.addButton(cancelBtn);
		toolBar.addButton(okBtn);

		
		this.window.setBottomToolbar(toolBar);
		
	}
	
	public void addComplexTabPanel(){
		
		this.tabPanel = new ComplexTabPanel();
		//this.tabPanel.setPixelSize(650, 500);
		this.tabPanel.setVisible(false);
		this.tabPanel.setTreePanelPixelSize(200, 500);
		this.window.add(tabPanel);
	}
	
	@Override
	public IComplexTabPanel getComplexTabPanel() {

		return tabPanel;
	}

	@Override
	public void close() {
		
		this.window.hide();
		
	}

	@Override
	public void open() {
		tabPanel.setVisible(true);
		window.show();
		
	}

	@Override
	public void refresh() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Widget asWidget() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void startProcessing() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void stopProcessing() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public IEditProjectConfigurationPanel getProjectConfigurationPanel() {
		return projectConfigurationPanel;
	}



	@Override
	public IButton getCancelButton() {

		return cancelBtn;
	}

	@Override
	public IButton getOkButton() {
		return okBtn;
	}

	@Override
	public void removePanel(IEditConfigurationPanel panel) {
		tabPanel.removePanel(panel);
	}

}
