/**
 * bpmn-deployer - Generic web application for BPMN deployment - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.bpmn.deployer.client.service;

import java.util.List;

import com.ebmwebsourcing.bpmn.deployer.client.exception.BPMNDeploymentException;
import com.ebmwebsourcing.bpmn.deployer.client.to.ProcessExecutorDescription;
import com.ebmwebsourcing.bpmn.deployer.client.to.RunningProcess;
import com.ebmwebsourcing.petalsbpm.business.domain.bpmn2.to.api.standard.infrastructure.IDefinitionsBean;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;

@RemoteServiceRelativePath("BPMNDeploymentService")
public interface BPMNDeploymentService extends RemoteService {

	/**
	 * @param processIds List of processes (of the current Definitions) that will be deployed
	 * @param BPMNFileAbsolutePath Absolute path of the file describing the current BPMN Definitions
	 * @param desc The description of the Process Executor which is targeted
	 * @throws BPMNDeploymentException
	 */
    public void deployBPMNProcessesFromFile(List<String> processIds, String BPMNFileAbsolutePath, ProcessExecutorDescription desc) throws BPMNDeploymentException;
    
    /**
	 * @param processIds List of processes (of the current Definitions) that will be deployed
	 * @param BPMNFileAbsolutePath Current BPMN definitions
	 * @param desc The description of the Process Executor which is targeted
	 * @throws BPMNDeploymentException
	 */
    public void deployBPMNProcesses(List<String> processIds, IDefinitionsBean BPMNDefinitions, ProcessExecutorDescription desc) throws BPMNDeploymentException;
    
    public List<RunningProcess> getDeployedProcesses(ProcessExecutorDescription desc) throws BPMNDeploymentException;
    
}
